/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components.internal;

import java.util.IdentityHashMap;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import vswe.superfactory.components.internal.ItemBufferElement;
import vswe.superfactory.components.internal.ItemSetting;
import vswe.superfactory.components.internal.Setting;
import vswe.superfactory.components.internal.SideSlotTarget;
import vswe.superfactory.components.internal.SlotInventoryHolder;

public class OutputItemCounter {
    private int currentBufferStackSize;
    private int currentInventoryStackSize;
    private ItemSetting setting;
    private boolean useWhiteList;

    public OutputItemCounter(List<ItemBufferElement> itemBuffer, List<SlotInventoryHolder> inventories, SlotInventoryHolder inventoryHolder, ItemSetting setting, boolean useWhiteList) {
        block6: {
            this.setting = setting;
            this.useWhiteList = useWhiteList;
            if (setting == null || setting.getItem() == null || !setting.isLimitedByAmount()) break block6;
            if (useWhiteList) {
                if (inventories.get(0).isShared()) {
                    for (SlotInventoryHolder slotInventoryHolder : inventories) {
                        this.addInventory(slotInventoryHolder);
                    }
                } else {
                    this.addInventory(inventoryHolder);
                }
            } else {
                for (ItemBufferElement itemBufferElement : itemBuffer) {
                    this.currentBufferStackSize += itemBufferElement.getBufferSize(setting);
                }
            }
        }
    }

    private void addInventory(SlotInventoryHolder inventoryHolder) {
        IdentityHashMap seenStacks = new IdentityHashMap();
        for (SideSlotTarget sideSlotTarget : inventoryHolder.getValidSlots().values()) {
            IItemHandler inventory = inventoryHolder.getInventory(sideSlotTarget.getSide());
            for (int slot : sideSlotTarget.getSlots()) {
                ItemStack item = inventory.getStackInSlot(slot);
                if (seenStacks.containsKey(item) || !this.setting.isEqualForCommandExecutor(item)) continue;
                seenStacks.put(item, null);
                this.currentInventoryStackSize += item.func_190916_E();
            }
        }
    }

    public boolean areSettingsSame(Setting setting) {
        return this.setting == null && setting == null || this.setting != null && setting != null && this.setting.getId() == setting.getId();
    }

    public int retrieveItemCount(int desiredItemCount) {
        if (this.setting == null || !this.setting.isLimitedByAmount()) {
            return desiredItemCount;
        }
        int itemsAllowedToBeMoved = this.useWhiteList ? this.setting.getAmount() - this.currentInventoryStackSize : this.currentBufferStackSize - this.setting.getAmount();
        return Math.min(itemsAllowedToBeMoved, desiredItemCount);
    }

    public void modifyStackSize(int itemsToMove) {
        if (this.useWhiteList) {
            this.currentInventoryStackSize += itemsToMove;
        } else {
            this.currentBufferStackSize -= itemsToMove;
        }
    }

    public String toString() {
        return "stack=" + (this.setting == null ? "unknown" : this.setting.getItem().toString()) + ", bufferStack=" + this.currentBufferStackSize + ", invStack=" + this.currentInventoryStackSize + (this.useWhiteList ? ", whitelisted" : "");
    }
}

