/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components;

import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.superfactory.Localization;
import vswe.superfactory.components.ComponentMenu;
import vswe.superfactory.components.FlowComponent;
import vswe.superfactory.components.Variable;
import vswe.superfactory.components.VariableDisplay;
import vswe.superfactory.interfaces.ContainerManager;
import vswe.superfactory.interfaces.GuiManager;
import vswe.superfactory.network.packets.DataBitHelper;
import vswe.superfactory.network.packets.DataReader;
import vswe.superfactory.network.packets.DataWriter;
import vswe.superfactory.network.packets.PacketHandler;

public class ComponentMenuVariableLoop
extends ComponentMenu {
    private static final int DISPLAY_X = 45;
    private static final int DISPLAY_Y_BOT = 25;
    private static final int DISPLAY_Y_TOP = 5;
    private static final String NBT_ELEMENT = "Element";
    private static final String NBT_LIST = "List";
    private VariableDisplay elementDisplay;
    private VariableDisplay listDisplay = new VariableDisplay(Localization.VARIABLE_LIST, 45, 5){

        @Override
        public int getValue() {
            return ComponentMenuVariableLoop.this.selectedList;
        }

        @Override
        public void setValue(int val) {
            ComponentMenuVariableLoop.this.selectedList = val;
        }

        @Override
        public void onUpdate() {
            ComponentMenuVariableLoop.this.sendServerData(true);
        }
    };
    private int selectedElement = 1;
    private int selectedList = 0;

    public ComponentMenuVariableLoop(FlowComponent parent) {
        super(parent);
        this.elementDisplay = new VariableDisplay(Localization.VARIABLE_ELEMENT, 45, 25){

            @Override
            public int getValue() {
                return ComponentMenuVariableLoop.this.selectedElement;
            }

            @Override
            public void setValue(int val) {
                ComponentMenuVariableLoop.this.selectedElement = val;
            }

            @Override
            public void onUpdate() {
                ComponentMenuVariableLoop.this.sendServerData(false);
            }
        };
    }

    private void sendServerData(boolean useList) {
        int val = useList ? this.selectedList : this.selectedElement;
        DataWriter dw = this.getWriterForServerComponentPacket();
        dw.writeBoolean(useList);
        dw.writeData(val, DataBitHelper.VARIABLE_TYPE);
        PacketHandler.sendDataToServer(dw);
    }

    @Override
    public String getName() {
        return Localization.LOOP_VARIABLE_MENU.toString();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        this.listDisplay.draw(gui, mX, mY);
        this.elementDisplay.draw(gui, mX, mY);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
        this.listDisplay.drawMouseOver(gui, mX, mY);
        this.elementDisplay.drawMouseOver(gui, mX, mY);
    }

    @Override
    public void onClick(int mX, int mY, int button) {
        this.listDisplay.onClick(mX, mY);
        this.elementDisplay.onClick(mX, mY);
    }

    @Override
    public void onDrag(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void onRelease(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void writeData(DataWriter dw) {
        dw.writeData(this.selectedList, DataBitHelper.VARIABLE_TYPE);
        dw.writeData(this.selectedElement, DataBitHelper.VARIABLE_TYPE);
    }

    @Override
    public void readData(DataReader dr) {
        this.selectedList = dr.readData(DataBitHelper.VARIABLE_TYPE);
        this.selectedElement = dr.readData(DataBitHelper.VARIABLE_TYPE);
    }

    @Override
    public void copyFrom(ComponentMenu menu) {
        this.selectedList = ((ComponentMenuVariableLoop)menu).selectedList;
        this.selectedElement = ((ComponentMenuVariableLoop)menu).selectedElement;
    }

    @Override
    public void refreshData(ContainerManager container, ComponentMenu newData) {
        ComponentMenuVariableLoop newDataLoop = (ComponentMenuVariableLoop)newData;
        if (this.selectedList != newDataLoop.selectedList) {
            this.selectedList = newDataLoop.selectedList;
            this.sendClientData(container, true);
        }
        if (this.selectedElement != newDataLoop.selectedElement) {
            this.selectedElement = newDataLoop.selectedElement;
            this.sendClientData(container, false);
        }
    }

    private void sendClientData(ContainerManager container, boolean useList) {
        int val = useList ? this.selectedList : this.selectedElement;
        DataWriter dw = this.getWriterForClientComponentPacket(container);
        dw.writeBoolean(useList);
        dw.writeData(val, DataBitHelper.VARIABLE_TYPE);
        PacketHandler.sendDataToListeningClients(container, dw);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound, int version, boolean pickup) {
        this.selectedList = nbtTagCompound.func_74771_c(NBT_LIST);
        this.selectedElement = nbtTagCompound.func_74771_c(NBT_ELEMENT);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
        nbtTagCompound.func_74774_a(NBT_LIST, (byte)this.selectedList);
        nbtTagCompound.func_74774_a(NBT_ELEMENT, (byte)this.selectedElement);
    }

    @Override
    public void addErrors(List<String> errors) {
        if (!this.getListVariable().isValid()) {
            errors.add(Localization.LIST_NOT_DECLARED.toString());
        }
        if (!this.getElementVariable().isValid()) {
            errors.add(Localization.ELEMENT_NOT_DECLARED.toString());
        }
    }

    public Variable getListVariable() {
        return this.getParent().getManager().getVariables()[this.selectedList];
    }

    public Variable getElementVariable() {
        return this.getParent().getManager().getVariables()[this.selectedElement];
    }

    @Override
    public void readNetworkComponent(DataReader dr) {
        boolean useList = dr.readBoolean();
        int val = dr.readData(DataBitHelper.VARIABLE_TYPE);
        if (useList) {
            this.selectedList = val;
        } else {
            this.selectedElement = val;
        }
    }
}

