/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.blocks;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import vswe.superfactory.SuperFactoryManager;
import vswe.superfactory.api.ICable;
import vswe.superfactory.blocks.BlockCable;
import vswe.superfactory.blocks.BlockCableCamouflages;
import vswe.superfactory.blocks.BlockCamouflageBase;
import vswe.superfactory.blocks.ItemCluster;
import vswe.superfactory.interfaces.IItemBlockProvider;
import vswe.superfactory.registry.ModBlocks;
import vswe.superfactory.tiles.TileEntityCluster;

public class BlockCableCluster
extends BlockCamouflageBase
implements ICable,
IItemBlockProvider {
    public static final IProperty ADVANCED = PropertyBool.func_177716_a((String)"advanced");
    public static final IProperty FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final IProperty FRONT = PropertyDirection.func_177714_a((String)"front");

    public BlockCableCluster() {
        super(Material.field_151573_f);
        this.func_149647_a(SuperFactoryManager.creativeTab);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(2.0f);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(ADVANCED, (Comparable)Boolean.valueOf(BlockCableCluster.isAdvanced(meta))).func_177226_a(FACING, (Comparable)this.getSide(meta)).func_177226_a(FRONT, (Comparable)this.getSide(meta).func_176734_d());
    }

    public int func_176201_c(IBlockState state) {
        return this.addAdvancedMeta(((EnumFacing)state.func_177229_b(FACING)).func_176745_a(), (Boolean)state.func_177229_b(ADVANCED) != false ? 8 : 0);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntityCluster cluster = this.getTe((IBlockAccess)world, pos);
        Block block = world.func_180495_p(pos).func_177230_c();
        if (cluster != null) {
            cluster.onNeighborBlockChange((IBlockAccess)world, pos, state, block);
        }
        if (BlockCableCluster.isAdvanced(state.func_177230_c().func_176201_c(state))) {
            BlockCable.updateInventories((IBlockAccess)world, pos);
        }
        super.func_189540_a(state, world, pos, blockIn, fromPos);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        TileEntityCluster cluster;
        if (world.func_175726_f(pos).func_177424_a(pos, null) != null && (cluster = this.getTe((IBlockAccess)world, pos)) != null) {
            cluster.onBlockAdded(world, pos, state);
        }
        if (BlockCableCluster.isAdvanced(state.func_177230_c().func_176201_c(state))) {
            BlockCable.updateInventories((IBlockAccess)world, pos);
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.getAdvancedMeta(state.func_177230_c().func_176201_c(state));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityCluster cluster = this.getTe((IBlockAccess)world, pos);
        if (cluster != null) {
            return cluster.onBlockActivated(world, pos, state, player, hand, player.func_184586_b(hand), facing, hitX, hitY, hitZ);
        }
        return false;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntityCluster cluster = this.getTe(world, pos);
        if (cluster != null) {
            return cluster.isProvidingWeakPower(state, world, pos, side);
        }
        return 0;
    }

    public int func_176211_b(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntityCluster cluster = this.getTe(blockAccess, pos);
        if (cluster != null) {
            return cluster.isProvidingStrongPower(state, blockAccess, pos, side);
        }
        return 0;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack itemStack) {
        TileEntityCluster cluster = this.getTe((IBlockAccess)world, pos);
        if (cluster != null) {
            cluster.loadElements(itemStack);
            cluster.onBlockPlacedBy(world, pos, state, entity, itemStack);
        }
    }

    private TileEntityCluster getTe(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityCluster) {
            return (TileEntityCluster)te;
        }
        return null;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public void func_149666_a(CreativeTabs item, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
        list.add((Object)new ItemStack((Block)this, 1, 8));
    }

    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{ADVANCED, FACING, FRONT};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{BlockCableCamouflages.BLOCK_POS};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drop = new ArrayList<ItemStack>();
        drop.add(this.getItemStack(world, pos, state));
        return drop;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntityCluster cluster = this.getTe(world, pos);
        if (cluster != null) {
            return cluster.canConnectRedstone(state, world, pos, side);
        }
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack itemStack = this.getItemStack((IBlockAccess)world, pos, world.func_180495_p(pos));
        if (!itemStack.func_190926_b()) {
            return itemStack;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    private ItemStack getItemStack(IBlockAccess world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityCluster) {
            TileEntityCluster cluster = (TileEntityCluster)te;
            ItemStack itemStack = new ItemStack(ModBlocks.CABLE_CLUSTER, 1, this.func_180651_a(state));
            NBTTagCompound compound = new NBTTagCompound();
            itemStack.func_77982_d(compound);
            NBTTagCompound cable = new NBTTagCompound();
            compound.func_74782_a("Cable", (NBTBase)cable);
            cable.func_74773_a("Types", cluster.getTypes());
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntityCluster cluster = this.getTe(world, pos);
        IBlockState state = world.func_180495_p(pos);
        Block block = world.func_180495_p(pos).func_177230_c();
        if (cluster != null) {
            cluster.onNeighborBlockChange(world, pos, state, block);
        }
        if (BlockCableCluster.isAdvanced(state.func_177230_c().func_176201_c(state))) {
            BlockCable.updateInventories(world, pos);
        }
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntityCluster cluster = this.getTe(world, pos);
        if (cluster != null) {
            return cluster.shouldCheckWeakPower(state, world, pos, side);
        }
        return false;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityCluster tileEntity = (TileEntityCluster)world.func_175625_s(pos);
        if (state instanceof IExtendedBlockState && tileEntity != null) {
            return ((IExtendedBlockState)state).withProperty((IUnlistedProperty)BlockCableCamouflages.BLOCK_POS, (Object)pos);
        }
        return state;
    }

    private int getAdvancedMeta(int meta) {
        return this.addAdvancedMeta(0, meta);
    }

    private int addAdvancedMeta(int meta, int advancedMeta) {
        return meta | advancedMeta & 8;
    }

    public static boolean isAdvanced(int meta) {
        return (meta & 8) != 0;
    }

    public EnumFacing getSide(int meta) {
        return EnumFacing.func_82600_a((int)this.getSideMeta(meta));
    }

    public int getSideMeta(int meta) {
        return meta & 7;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        if (BlockCableCluster.isAdvanced(state.func_177230_c().func_176201_c(state))) {
            BlockCable.updateInventories((IBlockAccess)world, pos);
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCluster();
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean isCable() {
        return true;
    }

    @Override
    public ItemBlock getItem() {
        return new ItemCluster((Block)this);
    }
}

