/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.common.ai.ChunkPositionSorter;
import me.desht.pneumaticcraft.common.block.BlockPressureTube;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IAutoFluidEjecting;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.ISerializableTanks;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.FluidUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityGasLift
extends TileEntityPneumaticBase
implements IMinWorkingPressure,
IRedstoneControlled,
ISerializableTanks,
IAutoFluidEjecting {
    private static final int INVENTORY_SIZE = 1;
    @GuiSynced
    private final FluidTank tank = new FluidTank(16000);
    private final ItemStackHandler inventory = new BaseItemStackHandler(this, 1){

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.func_190926_b() || itemStack.func_77973_b() instanceof ItemBlock && ((ItemBlock)itemStack.func_77973_b()).func_179223_d() instanceof BlockPressureTube;
        }
    };
    @GuiSynced
    public int currentDepth;
    @GuiSynced
    public int redstoneMode;
    @GuiSynced
    public int mode;
    @GuiSynced
    public Status status = Status.IDLE;
    @DescSynced
    public final boolean[] sidesConnected = new boolean[6];
    private int workTimer;
    private int ticker;
    private List<BlockPos> pumpingLake;
    private static final int MAX_PUMP_RANGE_SQUARED = 225;

    public TileEntityGasLift() {
        super(5.0f, 7.0f, 3000, 4);
        this.addApplicableUpgrade(IItemRegistry.EnumUpgrade.SPEED, IItemRegistry.EnumUpgrade.DISPENSER);
    }

    @Override
    public boolean isConnectedTo(EnumFacing d) {
        return d != EnumFacing.DOWN;
    }

    private void updateConnections() {
        List<Pair<EnumFacing, IAirHandler>> connections = this.getAirHandler(null).getConnectedPneumatics();
        Arrays.fill(this.sidesConnected, false);
        for (Pair<EnumFacing, IAirHandler> entry : connections) {
            this.sidesConnected[((EnumFacing)entry.getKey()).ordinal()] = true;
        }
    }

    @Override
    public void onNeighborBlockUpdate() {
        super.onNeighborBlockUpdate();
        this.updateConnections();
    }

    @Override
    public void onNeighborTileUpdate() {
        super.onNeighborTileUpdate();
        this.updateConnections();
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            int curCheckingPipe;
            ++this.ticker;
            if (this.currentDepth > 0 && (curCheckingPipe = this.ticker % this.currentDepth) > 0 && !this.isPipe(this.field_145850_b, this.func_174877_v().func_177967_a(EnumFacing.DOWN, curCheckingPipe))) {
                this.currentDepth = curCheckingPipe - 1;
            }
            if (this.ticker == 400) {
                this.pumpingLake = null;
                this.ticker = 0;
            }
            if (this.redstoneAllows() && this.getPressure() >= this.getMinWorkingPressure()) {
                this.workTimer = (int)((float)this.workTimer + this.getSpeedMultiplierFromUpgrades());
                while (this.workTimer > 20) {
                    this.workTimer -= 20;
                    this.status = Status.IDLE;
                    if (this.mode == 2) {
                        this.retractPipes();
                        continue;
                    }
                    if (this.suckLiquid() || this.tryDigDown()) continue;
                    break;
                }
            } else {
                this.status = Status.IDLE;
            }
        }
    }

    private void retractPipes() {
        if (this.currentDepth > 0) {
            this.status = Status.RETRACTING;
            if (this.isPipe(this.field_145850_b, this.func_174877_v().func_177982_a(0, -this.currentDepth, 0))) {
                BlockPos pos1 = this.func_174877_v().func_177967_a(EnumFacing.DOWN, this.currentDepth);
                ItemStack toInsert = new ItemStack(this.field_145850_b.func_180495_p(pos1).func_177230_c());
                if (this.inventory.insertItem(0, toInsert, true).func_190926_b()) {
                    this.inventory.insertItem(0, toInsert, false);
                    this.field_145850_b.func_175655_b(pos1, false);
                    this.addAir(-100);
                    --this.currentDepth;
                } else {
                    this.status = Status.IDLE;
                }
            } else {
                --this.currentDepth;
            }
        }
    }

    private boolean tryDigDown() {
        if (this.isUnbreakable(this.func_174877_v().func_177967_a(EnumFacing.DOWN, this.currentDepth + 1))) {
            this.status = Status.STUCK;
        } else if (this.func_174877_v().func_177956_o() - this.currentDepth >= 0) {
            this.status = Status.DIGGING;
            ++this.currentDepth;
            BlockPos pos1 = this.func_174877_v().func_177967_a(EnumFacing.DOWN, this.currentDepth);
            if (!this.isPipe(this.field_145850_b, pos1)) {
                ItemStack extracted = this.inventory.extractItem(0, 1, true);
                if (extracted.func_77973_b() instanceof ItemBlock) {
                    IBlockState currentState = this.field_145850_b.func_180495_p(pos1);
                    IBlockState newState = ((ItemBlock)extracted.func_77973_b()).func_179223_d().func_176223_P();
                    int airRequired = Math.round(66.66f * currentState.func_185887_b(this.field_145850_b, pos1));
                    if (this.getPipeTier(newState) > 1) {
                        airRequired /= 2;
                    }
                    if (this.getAirHandler(null).getAir() > airRequired) {
                        this.inventory.extractItem(0, 1, false);
                        this.field_145850_b.func_175655_b(pos1, false);
                        this.field_145850_b.func_175656_a(pos1, newState);
                        this.workTimer = 19;
                        this.addAir(-airRequired);
                    } else {
                        this.status = Status.IDLE;
                        --this.currentDepth;
                    }
                } else {
                    this.status = Status.IDLE;
                    --this.currentDepth;
                }
            }
        } else {
            this.status = Status.IDLE;
        }
        return this.status == Status.DIGGING;
    }

    private boolean isPipe(World world, BlockPos pos) {
        return this.getPipeTier(world.func_180495_p(pos)) >= 1;
    }

    private int getPipeTier(IBlockState state) {
        Block b = state.func_177230_c();
        return b instanceof BlockPressureTube ? ((BlockPressureTube)b).getTier() : 0;
    }

    private boolean isUnbreakable(BlockPos pos) {
        return this.world().func_180495_p(pos).func_185887_b(this.field_145850_b, pos) < 0.0f;
    }

    private boolean suckLiquid() {
        BlockPos pos = this.func_174877_v().func_177967_a(EnumFacing.DOWN, this.currentDepth + 1);
        FluidStack fluidStack = FluidUtils.getFluidAt(this.field_145850_b, pos, false);
        if (fluidStack == null || fluidStack.amount < 1000) {
            this.pumpingLake = null;
            return false;
        }
        if (this.tank.fill(fluidStack, false) == 1000) {
            FluidStack fluidStack1;
            if (this.pumpingLake == null) {
                this.findLake(fluidStack.getFluid());
            }
            boolean foundSource = false;
            BlockPos curPos = null;
            while (this.pumpingLake.size() > 0) {
                curPos = this.pumpingLake.get(0);
                if (FluidUtils.isSourceBlock(this.func_145831_w(), curPos, fluidStack.getFluid())) {
                    foundSource = true;
                    break;
                }
                this.pumpingLake.remove(0);
            }
            if (this.pumpingLake.isEmpty()) {
                this.pumpingLake = null;
            } else if (foundSource && (fluidStack1 = FluidUtils.getFluidAt(this.field_145850_b, curPos, true)) != null && fluidStack1.amount == 1000) {
                this.tank.fill(fluidStack1, true);
                this.addAir(-100);
                this.status = Status.PUMPING;
            }
        }
        return true;
    }

    private void findLake(Fluid fluid) {
        this.pumpingLake = new ArrayList<BlockPos>();
        Stack<BlockPos> pendingPositions = new Stack<BlockPos>();
        BlockPos thisPos = this.func_174877_v().func_177967_a(EnumFacing.DOWN, this.currentDepth + 1);
        pendingPositions.add(thisPos);
        this.pumpingLake.add(thisPos);
        while (!pendingPositions.empty()) {
            BlockPos checkingPos = (BlockPos)pendingPositions.pop();
            for (EnumFacing d : EnumFacing.field_82609_l) {
                BlockPos newPos;
                if (d == EnumFacing.DOWN || !(PneumaticCraftUtils.distBetweenSq(newPos = checkingPos.func_177972_a(d), thisPos) <= 225.0) || !FluidUtils.isSourceBlock(this.func_145831_w(), newPos, fluid) || this.pumpingLake.contains(newPos)) continue;
                pendingPositions.add(newPos);
                this.pumpingLake.add(newPos);
            }
        }
        this.pumpingLake.sort(new ChunkPositionSorter((double)this.func_174877_v().func_177958_n() + 0.5, this.func_174877_v().func_177956_o() - this.currentDepth - 1, (double)this.func_174877_v().func_177952_p() + 0.5));
        Collections.reverse(this.pumpingLake);
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        } else if (buttonID > 0 && buttonID < 4) {
            this.mode = buttonID - 1;
        }
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public float getMinWorkingPressure() {
        return 0.5f + (float)this.currentDepth * 0.05f;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("Items", (NBTBase)this.inventory.serializeNBT());
        tag.func_74774_a("redstoneMode", (byte)this.redstoneMode);
        tag.func_74774_a("mode", (byte)this.mode);
        NBTTagCompound tankTag = new NBTTagCompound();
        this.tank.writeToNBT(tankTag);
        tag.func_74782_a("tank", (NBTBase)tankTag);
        tag.func_74768_a("currentDepth", this.currentDepth);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
        this.redstoneMode = tag.func_74771_c("redstoneMode");
        this.mode = tag.func_74771_c("mode");
        this.tank.readFromNBT(tag.func_74775_l("tank"));
        this.currentDepth = tag.func_74762_e("currentDepth");
    }

    @Override
    public IItemHandlerModifiable getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        return super.getCapability(capability, facing);
    }

    public FluidTank getTank() {
        return this.tank;
    }

    @Override
    public String getName() {
        return Blockss.GAS_LIFT.func_149739_a();
    }

    @Override
    @Nonnull
    public Map<String, FluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"Tank", (Object)this.tank);
    }

    public static enum Status {
        IDLE("idling"),
        PUMPING("pumping"),
        DIGGING("diggingDown"),
        RETRACTING("retracting"),
        STUCK("stuck");

        public final String desc;

        private Status(String desc) {
            this.desc = desc;
        }
    }
}

