/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.common.block.BlockElectrostaticCompressor;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileEntityElectrostaticCompressor
extends TileEntityPneumaticBase
implements IRedstoneControl {
    @GameRegistry.ObjectHolder(value="chisel:ironpane")
    private static final Block CHISELED_BARS = null;
    private static final List<String> REDSTONE_LABELS = ImmutableList.of((Object)"gui.tab.redstoneBehaviour.button.never", (Object)"gui.tab.redstoneBehaviour.electrostaticCompressor.button.struckByLightning");
    private static final int MAX_ELECTROSTATIC_GRID_SIZE = 250;
    private static final int MAX_BARS_ABOVE = 10;
    private boolean lastRedstoneState;
    @GuiSynced
    public int redstoneMode = 0;
    public int ironBarsBeneath = 0;
    public int ironBarsAbove = 0;
    private int struckByLightningCooldown;

    public TileEntityElectrostaticCompressor() {
        super(20.0f, 25.0f, 50000, 4);
    }

    @Override
    public void func_73660_a() {
        if ((this.func_145831_w().func_82737_E() & 0x1FL) == 0L) {
            int max = 20;
            this.ironBarsBeneath = 0;
            while (this.ironBarsBeneath < max && TileEntityElectrostaticCompressor.isValidGridBlock(this.func_145831_w().func_180495_p(this.func_174877_v().func_177979_c(this.ironBarsBeneath + 1)).func_177230_c())) {
                ++this.ironBarsBeneath;
            }
            this.ironBarsAbove = 0;
            while (this.ironBarsAbove < 10 && TileEntityElectrostaticCompressor.isValidGridBlock(this.func_145831_w().func_180495_p(this.func_174877_v().func_177981_b(this.ironBarsAbove + 1)).func_177230_c())) {
                ++this.ironBarsAbove;
            }
        }
        super.func_73660_a();
        this.maybeLightningStrike();
        if (!this.func_145831_w().field_72995_K) {
            if (this.lastRedstoneState != this.shouldEmitRedstone()) {
                this.lastRedstoneState = !this.lastRedstoneState;
                this.updateNeighbours();
            }
            --this.struckByLightningCooldown;
        }
    }

    public int getStrikeChance() {
        int strikeChance = ConfigHandler.machineProperties.electrostaticLightningChance;
        if (this.func_145831_w().func_72896_J()) {
            strikeChance = (int)((double)strikeChance * 0.5);
        }
        if (this.func_145831_w().func_72911_I()) {
            strikeChance = (int)((double)strikeChance * 0.2);
        }
        strikeChance = (int)((float)strikeChance * (1.0f - 0.02f * (float)this.ironBarsAbove));
        return strikeChance;
    }

    private void maybeLightningStrike() {
        Random rnd = this.func_145831_w().field_73012_v;
        if (rnd.nextInt(this.getStrikeChance()) == 0) {
            int dist = rnd.nextInt(6);
            float angle = rnd.nextFloat() * (float)Math.PI;
            int x = (int)((float)this.func_174877_v().func_177958_n() + (float)dist * MathHelper.func_76126_a((float)angle));
            int z = (int)((float)this.func_174877_v().func_177952_p() + (float)dist * MathHelper.func_76134_b((float)angle));
            for (int y = this.func_174877_v().func_177956_o() + 5; y > this.func_174877_v().func_177956_o() - 5; --y) {
                BlockPos hitPos = new BlockPos(x, y, z);
                IBlockState state = this.func_145831_w().func_180495_p(hitPos);
                if (!(state.func_177230_c() instanceof BlockElectrostaticCompressor) && state.func_177230_c() != Blocks.field_150411_aY) continue;
                HashSet<BlockPos> posSet = new HashSet<BlockPos>();
                this.getElectrostaticGrid(posSet, this.func_145831_w(), hitPos, null);
                List compressors = posSet.stream().filter(pos -> this.field_145850_b.func_180495_p(pos).func_177230_c() == Blockss.ELECTROSTATIC_COMPRESSOR).map(pos -> this.field_145850_b.func_175625_s(pos)).filter(te -> te instanceof TileEntityElectrostaticCompressor).map(te -> (TileEntityElectrostaticCompressor)te).collect(Collectors.toList());
                EntityLightningBolt bolt = new EntityLightningBolt(this.func_145831_w(), (double)x, (double)y, (double)z, true);
                this.func_145831_w().func_72838_d((Entity)bolt);
                for (TileEntityElectrostaticCompressor compressor : compressors) {
                    compressor.addAir(200000 / compressors.size());
                    compressor.onStruckByLightning();
                }
                AxisAlignedBB box = new AxisAlignedBB(this.func_174877_v()).func_72314_b(16.0, 16.0, 16.0);
                for (EntityLivingBase entity : this.func_145831_w().func_175647_a(EntityLivingBase.class, box, EntitySelectors.field_94557_a)) {
                    if (!posSet.contains(entity.func_180425_c()) && !posSet.contains(entity.func_180425_c().func_177977_b()) || ForgeEventFactory.onEntityStruckByLightning((Entity)entity, (EntityLightningBolt)bolt)) continue;
                    entity.func_70077_a(bolt);
                }
                break;
            }
        }
    }

    @Override
    public boolean isConnectedTo(EnumFacing dir) {
        return dir != EnumFacing.UP;
    }

    private boolean shouldEmitRedstone() {
        switch (this.redstoneMode) {
            case 0: {
                return false;
            }
            case 1: {
                return this.struckByLightningCooldown > 0;
            }
        }
        return false;
    }

    public void onStruckByLightning() {
        this.struckByLightningCooldown = 10;
        if (this.getPressure() > 20.0f) {
            int maxRedirection = 10000 * this.ironBarsBeneath;
            int tooMuchAir = (int)((this.getPressure() - 20.0f) * (float)this.getAirHandler(null).getVolume());
            this.addAir(-Math.min(maxRedirection, tooMuchAir));
        }
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 1) {
                this.redstoneMode = 0;
            }
        }
    }

    @Override
    public String getName() {
        return Blockss.ELECTROSTATIC_COMPRESSOR.func_149739_a();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.redstoneMode = nbtTagCompound.func_74762_e("redstoneMode");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("redstoneMode", this.redstoneMode);
        return nbtTagCompound;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    protected List<String> getRedstoneButtonLabels() {
        return REDSTONE_LABELS;
    }

    public void getElectrostaticGrid(Set<BlockPos> set, World world, BlockPos pos, EnumFacing dir) {
        for (EnumFacing d : EnumFacing.field_82609_l) {
            BlockPos newPos;
            Block block;
            if (d == dir || !TileEntityElectrostaticCompressor.isValidGridBlock(block = world.func_180495_p(newPos = pos.func_177972_a(d)).func_177230_c()) && block != Blockss.ELECTROSTATIC_COMPRESSOR || set.size() >= 250 || !set.add(newPos)) continue;
            this.getElectrostaticGrid(set, world, newPos, d.func_176734_d());
        }
    }

    private static boolean isValidGridBlock(Block block) {
        return block == Blocks.field_150411_aY || block == CHISELED_BARS;
    }
}

