/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.item.IPressurizable;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.inventory.ContainerChargingStationItemInventory;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.inventory.handler.ChargeableItemHandler;
import me.desht.pneumaticcraft.common.item.IChargingStationGUIHolderItem;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.GlobalTileEntityCacheManager;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityChargingStation
extends TileEntityPneumaticBase
implements IRedstoneControl,
ICamouflageableTE {
    private static final List<String> REDSTONE_LABELS = ImmutableList.of((Object)"gui.tab.redstoneBehaviour.button.never", (Object)"gui.tab.redstoneBehaviour.chargingStation.button.doneDischarging", (Object)"gui.tab.redstoneBehaviour.chargingStation.button.charging", (Object)"gui.tab.redstoneBehaviour.chargingStation.button.discharging");
    @DescSynced
    public ItemStack chargingStackSynced = ItemStack.field_190927_a;
    private ChargingStationHandler inventory;
    private ChargeableItemHandler chargeableInventory;
    private static final int INVENTORY_SIZE = 1;
    public static final int CHARGE_INVENTORY_INDEX = 0;
    @GuiSynced
    public float chargingItemPressure;
    @GuiSynced
    public boolean charging;
    @GuiSynced
    public boolean discharging;
    @GuiSynced
    public int redstoneMode;
    private boolean oldRedstoneStatus;
    @DescSynced
    private ItemStack camoStack = ItemStack.field_190927_a;
    private IBlockState camoState;
    @DescSynced
    public boolean dispenserUpgradeInserted;

    public TileEntityChargingStation() {
        super(20.0f, 25.0f, 1000, 4);
        this.inventory = new ChargingStationHandler();
        this.addApplicableUpgrade(IItemRegistry.EnumUpgrade.SPEED, IItemRegistry.EnumUpgrade.DISPENSER);
    }

    @Override
    public void onDescUpdate() {
        this.camoState = ICamouflageableTE.getStateForStack(this.camoStack);
        super.onDescUpdate();
    }

    @Nonnull
    public ItemStack getChargingStack() {
        return this.inventory.getStackInSlot(0);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            List<Pair<EnumFacing, IAirHandler>> teList;
            this.discharging = false;
            this.charging = false;
            this.chargingStackSynced = this.inventory.getStackInSlot(0);
            int airToTransfer = (int)(10.0f * this.getSpeedMultiplierFromUpgrades());
            List<Pair<IPressurizable, ItemStack>> l = this.findChargeableItems();
            for (int i = 0; i < l.size() && this.airHandler.getAir() > 0; ++i) {
                IPressurizable p = (IPressurizable)l.get(i).getLeft();
                ItemStack chargingStack = (ItemStack)l.get(i).getRight();
                float itemPressure = p.getPressure(chargingStack);
                float itemVolume = p.getVolume(chargingStack);
                float delta = Math.abs(this.getPressure() - itemPressure) / 2.0f;
                int airInItem = (int)(itemPressure * itemVolume);
                if (itemPressure > this.getPressure() + 0.01f && itemPressure > 0.0f) {
                    int airToMove = Math.min(Math.min(airToTransfer, airInItem), (int)(delta * (float)this.airHandler.getVolume()));
                    p.addAir(chargingStack, -airToMove);
                    this.addAir(airToMove);
                    this.discharging = true;
                    continue;
                }
                if (!(itemPressure < this.getPressure() - 0.01f) || !(itemPressure < p.maxPressure(chargingStack))) continue;
                int maxAirInItem = (int)(p.maxPressure(chargingStack) * itemVolume);
                int airToMove = Math.min(Math.min(airToTransfer, this.airHandler.getAir()), maxAirInItem - airInItem);
                airToMove = Math.min((int)(delta * itemVolume), airToMove);
                p.addAir(chargingStack, airToMove);
                this.addAir(-airToMove);
                this.charging = true;
            }
            if (this.oldRedstoneStatus != this.shouldEmitRedstone()) {
                this.oldRedstoneStatus = this.shouldEmitRedstone();
                this.updateNeighbours();
            }
            if ((teList = this.getAirHandler(null).getConnectedPneumatics()).size() == 0) {
                this.getAirHandler(null).airLeak(this.getRotation());
            }
        }
    }

    @Override
    protected void onFirstServerUpdate() {
        super.onFirstServerUpdate();
        this.chargingStackSynced = new ItemStack(this.getChargingStack().func_77973_b());
        this.dispenserUpgradeInserted = this.getUpgrades(IItemRegistry.EnumUpgrade.DISPENSER) > 0;
    }

    private List<Pair<IPressurizable, ItemStack>> findChargeableItems() {
        ArrayList<Pair<IPressurizable, ItemStack>> res = new ArrayList<Pair<IPressurizable, ItemStack>>();
        IPressurizable p = IPressurizable.of(this.getChargingStack());
        if (p != null) {
            res.add(Pair.of((Object)p, (Object)this.getChargingStack()));
            this.chargingItemPressure = p.getPressure(this.getChargingStack());
        }
        if (this.getUpgrades(IItemRegistry.EnumUpgrade.DISPENSER) > 0) {
            List entitiesPadding = this.func_145831_w().func_72872_a(Entity.class, new AxisAlignedBB(this.func_174877_v().func_177984_a()));
            for (Entity entity : entitiesPadding) {
                if (entity instanceof IPressurizable) {
                    res.add((Pair<IPressurizable, ItemStack>)Pair.of((Object)((IPressurizable)entity), (Object)ItemStack.field_190927_a));
                    continue;
                }
                if (entity instanceof EntityItem) {
                    ItemStack entityStack = ((EntityItem)entity).func_92059_d();
                    if (!(entityStack.func_77973_b() instanceof IPressurizable)) continue;
                    res.add((Pair<IPressurizable, ItemStack>)Pair.of((Object)IPressurizable.of(entityStack), (Object)entityStack));
                    continue;
                }
                if (!(entity instanceof EntityPlayer)) continue;
                InventoryPlayer inv = ((EntityPlayer)entity).field_71071_by;
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack stack = inv.func_70301_a(i);
                    if (!(stack.func_77973_b() instanceof IPressurizable)) continue;
                    res.add((Pair<IPressurizable, ItemStack>)Pair.of((Object)IPressurizable.of(stack), (Object)stack));
                }
            }
        }
        return res;
    }

    @Override
    public boolean isConnectedTo(EnumFacing side) {
        return this.getRotation() == side;
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 3) {
                this.redstoneMode = 0;
            }
            this.updateNeighbours();
        } else if ((buttonID == 1 || buttonID == 2) && this.getChargingStack().func_77973_b() instanceof IChargingStationGUIHolderItem) {
            player.openGui((Object)PneumaticCraftRepressurized.instance, buttonID == 1 ? ((IChargingStationGUIHolderItem)this.getChargingStack().func_77973_b()).getGuiID().ordinal() : GuiHandler.EnumGuiId.CHARGING_STATION.ordinal(), this.func_145831_w(), this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
        }
    }

    public boolean shouldEmitRedstone() {
        switch (this.redstoneMode) {
            case 0: {
                return false;
            }
            case 1: {
                return !this.charging && !this.discharging && this.getChargingStack().func_77973_b() instanceof IPressurizable;
            }
            case 2: {
                return this.charging;
            }
            case 3: {
                return this.discharging;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1));
    }

    public ChargeableItemHandler getChargeableInventory() {
        return this.func_145831_w().field_72995_K ? new ChargeableItemHandler(this) : this.chargeableInventory;
    }

    @Override
    public IItemHandlerModifiable getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    public String getName() {
        return Blockss.CHARGING_STATION.func_149739_a();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.redstoneMode = tag.func_74762_e("redstoneMode");
        this.inventory = new ChargingStationHandler();
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
        ItemStack chargeSlot = this.getChargingStack();
        if (chargeSlot.func_77973_b() instanceof IChargingStationGUIHolderItem) {
            this.chargeableInventory = new ChargeableItemHandler(this);
        }
        this.camoStack = ICamouflageableTE.readCamoStackFromNBT(tag);
        this.camoState = ICamouflageableTE.getStateForStack(this.camoStack);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.chargeableInventory != null) {
            this.chargeableInventory.writeToNBT();
        }
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        tag.func_74782_a("Items", (NBTBase)this.inventory.serializeNBT());
        ICamouflageableTE.writeCamoStackToNBT(this.camoStack, tag);
        return tag;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.chargeableInventory != null) {
            this.chargeableInventory.writeToNBT();
        }
    }

    @Override
    protected void onUpgradesChanged() {
        super.onUpgradesChanged();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.dispenserUpgradeInserted = this.getUpgrades(IItemRegistry.EnumUpgrade.DISPENSER) > 0;
        }
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    protected List<String> getRedstoneButtonLabels() {
        return REDSTONE_LABELS;
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public IBlockState getCamouflage() {
        return this.camoState;
    }

    @Override
    public void setCamouflage(IBlockState state) {
        this.camoState = state;
        this.camoStack = ICamouflageableTE.getStackForState(state);
        this.sendDescriptionPacket();
        this.func_70296_d();
    }

    public void func_145843_s() {
        super.func_145843_s();
        GlobalTileEntityCacheManager.getInstance().chargingStations.remove(this);
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        GlobalTileEntityCacheManager.getInstance().chargingStations.add(this);
    }

    private class ChargingStationHandler
    extends BaseItemStackHandler {
        ChargingStationHandler() {
            super(TileEntityChargingStation.this, 1);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return slot == 0 && (itemStack.func_190926_b() || itemStack.func_77973_b() instanceof IPressurizable);
        }

        @Override
        protected void onContentsChanged(int slot) {
            TileEntityChargingStation teCS = TileEntityChargingStation.this;
            ItemStack newStack = this.getStackInSlot(slot);
            if (!ItemStack.func_179545_c((ItemStack)TileEntityChargingStation.this.chargingStackSynced, (ItemStack)newStack)) {
                TileEntityChargingStation.this.chargingStackSynced = new ItemStack(newStack.func_77973_b());
            }
            if (teCS.func_145831_w().field_72995_K || slot != 0) {
                return;
            }
            teCS.chargeableInventory = newStack.func_77973_b() instanceof IChargingStationGUIHolderItem ? new ChargeableItemHandler(teCS) : null;
            for (EntityPlayer player : teCS.func_145831_w().field_73010_i) {
                if (!(player.field_71070_bA instanceof ContainerChargingStationItemInventory) || ((ContainerChargingStationItemInventory)player.field_71070_bA).te != this.te) continue;
                player.openGui((Object)PneumaticCraftRepressurized.instance, GuiHandler.EnumGuiId.CHARGING_STATION.ordinal(), teCS.func_145831_w(), teCS.func_174877_v().func_177958_n(), teCS.func_174877_v().func_177956_o(), teCS.func_174877_v().func_177952_p());
            }
        }
    }
}

