/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.sensor.pollSensors;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.tileentity.IHeatExchanger;
import me.desht.pneumaticcraft.api.universalSensor.IBlockAndCoordinatePollSensor;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.item.Itemss;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.math.NumberUtils;
import org.lwjgl.util.Rectangle;

public class BlockHeatSensor
implements IBlockAndCoordinatePollSensor {
    @Override
    public String getSensorPath() {
        return "Block/Heat";
    }

    @Override
    public Set<Item> getRequiredUpgrades() {
        return ImmutableSet.of((Object)Itemss.upgrades.get(IItemRegistry.EnumUpgrade.BLOCK_TRACKER), (Object)Itemss.GPS_TOOL);
    }

    @Override
    public int getPollFrequency() {
        return 20;
    }

    @Override
    public boolean needsTextBox() {
        return true;
    }

    @Override
    public List<String> getDescription() {
        ArrayList<String> text = new ArrayList<String>();
        text.add(TextFormatting.BLACK + I18n.func_135052_a((String)"gui.universalSensor.desc.heatSensor", (Object[])new Object[0]));
        return text;
    }

    @Override
    public int getRedstoneValue(World world, BlockPos pos, int sensorRange, String textBoxText, Set<BlockPos> positions) {
        double temperature = Double.MIN_VALUE;
        for (BlockPos p : positions) {
            TileEntity te = world.func_175625_s(p);
            if (!(te instanceof IHeatExchanger)) continue;
            IHeatExchanger exchanger = (IHeatExchanger)te;
            for (EnumFacing d : EnumFacing.field_82609_l) {
                IHeatExchangerLogic logic = exchanger.getHeatExchangerLogic(d);
                if (logic == null) continue;
                temperature = Math.max(temperature, logic.getTemperature());
            }
        }
        return NumberUtils.isCreatable((String)textBoxText) ? (temperature - 273.0 > (double)NumberUtils.toInt((String)textBoxText) ? 15 : 0) : HeatUtil.getComparatorOutput((int)temperature);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawAdditionalInfo(FontRenderer fontRenderer) {
        fontRenderer.func_78276_b("Temperature", 70, 48, 0x404040);
    }

    @Override
    public Rectangle needsSlot() {
        return null;
    }
}

