/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.programs;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.common.recipes.AssemblyRecipe;
import me.desht.pneumaticcraft.common.recipes.programs.AssemblyProgram;
import me.desht.pneumaticcraft.common.recipes.programs.ProgramDrill;
import me.desht.pneumaticcraft.common.recipes.programs.ProgramLaser;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyController;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ProgramDrillLaser
extends AssemblyProgram {
    @Override
    public AssemblyProgram.EnumMachine[] getRequiredMachines() {
        return new AssemblyProgram.EnumMachine[]{AssemblyProgram.EnumMachine.PLATFORM, AssemblyProgram.EnumMachine.IO_UNIT_EXPORT, AssemblyProgram.EnumMachine.IO_UNIT_IMPORT, AssemblyProgram.EnumMachine.DRILL, AssemblyProgram.EnumMachine.LASER};
    }

    @Override
    public boolean executeStep(TileEntityAssemblyController.AssemblySystem system) {
        boolean useAir = true;
        if (!system.getPlatform().getHeldStack().func_190926_b()) {
            if (this.canItemBeDrilled(system.getPlatform().getHeldStack())) {
                system.getDrill().goDrilling();
            } else if (system.getDrill().isIdle() && this.canItemBeLasered(system.getPlatform().getHeldStack())) {
                system.getLaser().startLasering();
            } else if (system.getDrill().isIdle() && system.getLaser().isIdle()) {
                useAir = system.getExportUnit().pickupItem(null);
            }
        } else if (!system.getExportUnit().isIdle()) {
            useAir = system.getExportUnit().pickupItem(null);
        } else {
            ArrayList<AssemblyRecipe> recipes = new ArrayList<AssemblyRecipe>();
            recipes.addAll(this.getRecipeList());
            recipes.addAll(new ProgramDrill().getRecipeList());
            recipes.addAll(new ProgramLaser().getRecipeList());
            useAir = system.getImportUnit().pickupItem(recipes);
        }
        return useAir;
    }

    private boolean canItemBeLasered(ItemStack item) {
        for (AssemblyRecipe recipe : AssemblyRecipe.laserRecipes) {
            if (!ProgramDrillLaser.isValidInput(recipe, item)) continue;
            return true;
        }
        return false;
    }

    private boolean canItemBeDrilled(ItemStack item) {
        for (AssemblyRecipe recipe : AssemblyRecipe.drillRecipes) {
            if (!ProgramDrillLaser.isValidInput(recipe, item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
    }

    @Override
    public List<AssemblyRecipe> getRecipeList() {
        return AssemblyRecipe.drillLaserRecipes;
    }

    @Override
    protected int getItemMeta() {
        return 2;
    }
}

