/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes;

import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import me.desht.pneumaticcraft.common.DroneRegistry;
import me.desht.pneumaticcraft.common.config.AmadronOfferSettings;
import me.desht.pneumaticcraft.common.inventory.ContainerAmadron;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAmadronTradeNotifyDeal;
import me.desht.pneumaticcraft.common.network.PacketSyncAmadronOffers;
import me.desht.pneumaticcraft.common.recipes.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.AmadronOfferManager;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class AmadronOfferCustom
extends AmadronOffer {
    private final String offeringPlayerName;
    private String offeringPlayerId;
    private int providingDimensionId;
    private int returningDimensionId;
    private BlockPos providingPosition;
    private BlockPos returningPosition;
    private int inStock;
    private int maxTrades = -1;
    private int pendingPayments;
    private TileEntity cachedInput;
    private TileEntity cachedOutput;

    public AmadronOfferCustom(Object input, Object output, EntityPlayer offeringPlayer) {
        this(input, output, offeringPlayer.func_146103_bH().getName(), offeringPlayer.func_146103_bH().getId().toString());
    }

    public AmadronOfferCustom(Object input, Object output, String playerName, String playerId) {
        super(input, output);
        this.offeringPlayerName = playerName;
        this.offeringPlayerId = playerId;
    }

    public AmadronOfferCustom setProvidingPosition(BlockPos pos, int dimensionId) {
        this.providingPosition = pos;
        this.providingDimensionId = dimensionId;
        this.cachedInput = null;
        return this;
    }

    public AmadronOfferCustom setReturningPosition(BlockPos pos, int dimensionId) {
        this.returningPosition = pos;
        this.returningDimensionId = dimensionId;
        this.cachedOutput = null;
        return this;
    }

    public AmadronOfferCustom invert() {
        Object temp = this.input;
        this.input = this.output;
        this.output = temp;
        return this;
    }

    public AmadronOfferCustom copy() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return AmadronOfferCustom.loadFromNBT(tag);
    }

    public void updatePlayerId() {
        EntityPlayer player = PneumaticCraftUtils.getPlayerFromName(this.offeringPlayerName);
        if (player != null) {
            this.offeringPlayerId = player.func_146103_bH().getId().toString();
        }
    }

    public void addStock(int stock) {
        this.inStock += stock;
    }

    @Override
    public int getStock() {
        return this.inStock;
    }

    public void addPayment(int payment) {
        this.pendingPayments += payment;
    }

    public void setMaxTrades(int maxTrades) {
        this.maxTrades = maxTrades;
    }

    @Override
    public String getVendor() {
        return this.offeringPlayerName;
    }

    public String getPlayerId() {
        return this.offeringPlayerId;
    }

    @Override
    public void onTrade(int tradingAmount, String buyingPlayer) {
        EntityPlayer player = PneumaticCraftUtils.getPlayerFromId(this.offeringPlayerId);
        if (player != null && AmadronOfferSettings.notifyOfDealMade) {
            NetworkHandler.sendTo(new PacketAmadronTradeNotifyDeal(this, tradingAmount, buyingPlayer), (EntityPlayerMP)player);
        }
    }

    boolean payout() {
        boolean paid = false;
        TileEntity returning = this.getReturningTileEntity();
        if (this.pendingPayments > 0) {
            int paying = Math.min(this.pendingPayments, 50);
            if ((paying = ContainerAmadron.capShoppingAmount(this, paying, null, AmadronOfferManager.getItemHandler(returning), null, AmadronOfferManager.getFluidHandler(returning), null)) > 0) {
                this.pendingPayments -= paying;
                paid = true;
                if (this.getInput() instanceof ItemStack) {
                    ItemStack stack;
                    ItemStack deliveringItems = (ItemStack)this.getInput();
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    for (int amount = deliveringItems.func_190916_E() * paying; amount > 0; amount -= stack.func_190916_E()) {
                        stack = deliveringItems.func_77946_l();
                        stack.func_190920_e(Math.min(amount, stack.func_77976_d()));
                        stacks.add(stack);
                    }
                    DroneRegistry.getInstance().deliverItemsAmazonStyle(returning.func_145831_w(), returning.func_174877_v(), stacks.toArray(new ItemStack[0]));
                } else {
                    FluidStack deliveringFluid = ((FluidStack)this.getInput()).copy();
                    deliveringFluid.amount *= paying;
                    DroneRegistry.getInstance().deliverFluidAmazonStyle(returning.func_145831_w(), returning.func_174877_v(), deliveringFluid);
                }
            }
        }
        return paid;
    }

    public void returnStock() {
        TileEntity provider = this.getProvidingTileEntity();
        TileEntity returning = this.getReturningTileEntity();
        this.invert();
        while (this.inStock > 0) {
            int stock = Math.min(this.inStock, 50);
            if ((stock = ContainerAmadron.capShoppingAmount(this, stock, AmadronOfferManager.getItemHandler(returning), AmadronOfferManager.getItemHandler(provider), AmadronOfferManager.getFluidHandler(returning), AmadronOfferManager.getFluidHandler(provider), null)) <= 0) break;
            this.inStock -= stock;
            if (this.getInput() instanceof ItemStack) {
                ItemStack stack;
                ItemStack deliveringItems = (ItemStack)this.getInput();
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (int amount = deliveringItems.func_190916_E() * stock; amount > 0; amount -= stack.func_190916_E()) {
                    stack = deliveringItems.func_77946_l();
                    stack.func_190920_e(Math.min(amount, stack.func_77976_d()));
                    stacks.add(stack);
                }
                DroneRegistry.getInstance().deliverItemsAmazonStyle(provider.func_145831_w(), provider.func_174877_v(), stacks.toArray(new ItemStack[0]));
                continue;
            }
            FluidStack deliveringFluid = ((FluidStack)this.getInput()).copy();
            deliveringFluid.amount *= stock;
            DroneRegistry.getInstance().deliverFluidAmazonStyle(provider.func_145831_w(), provider.func_174877_v(), deliveringFluid);
        }
    }

    public TileEntity getProvidingTileEntity() {
        if ((this.cachedInput == null || this.cachedInput.func_145837_r()) && this.providingPosition != null) {
            this.cachedInput = PneumaticCraftUtils.getTileEntity(this.providingPosition, this.providingDimensionId);
        }
        return this.cachedInput;
    }

    public TileEntity getReturningTileEntity() {
        if ((this.cachedOutput == null || this.cachedOutput.func_145837_r()) && this.returningPosition != null) {
            this.cachedOutput = PneumaticCraftUtils.getTileEntity(this.returningPosition, this.returningDimensionId);
        }
        return this.cachedOutput;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74778_a("offeringPlayerId", this.offeringPlayerId);
        tag.func_74778_a("offeringPlayerName", this.offeringPlayerName);
        tag.func_74768_a("inStock", this.inStock);
        tag.func_74768_a("maxTrades", this.maxTrades);
        tag.func_74768_a("pendingPayments", this.pendingPayments);
        if (this.providingPosition != null) {
            tag.func_74768_a("providingDimensionId", this.providingDimensionId);
            tag.func_74768_a("providingX", this.providingPosition.func_177958_n());
            tag.func_74768_a("providingY", this.providingPosition.func_177956_o());
            tag.func_74768_a("providingZ", this.providingPosition.func_177952_p());
        }
        if (this.returningPosition != null) {
            tag.func_74768_a("returningDimensionId", this.returningDimensionId);
            tag.func_74768_a("returningX", this.returningPosition.func_177958_n());
            tag.func_74768_a("returningY", this.returningPosition.func_177956_o());
            tag.func_74768_a("returningZ", this.returningPosition.func_177952_p());
        }
    }

    public static AmadronOfferCustom loadFromNBT(NBTTagCompound tag) {
        AmadronOffer offer = AmadronOffer.loadFromNBT(tag);
        AmadronOfferCustom custom = new AmadronOfferCustom(offer.getInput(), offer.getOutput(), tag.func_74779_i("offeringPlayerName"), tag.func_74779_i("offeringPlayerId"));
        custom.inStock = tag.func_74762_e("inStock");
        custom.maxTrades = tag.func_74762_e("maxTrades");
        custom.pendingPayments = tag.func_74762_e("pendingPayments");
        if (tag.func_74764_b("providingDimensionId")) {
            custom.setProvidingPosition(new BlockPos(tag.func_74762_e("providingX"), tag.func_74762_e("providingY"), tag.func_74762_e("providingZ")), tag.func_74762_e("providingDimensionId"));
        }
        if (tag.func_74764_b("returningDimensionId")) {
            custom.setReturningPosition(new BlockPos(tag.func_74762_e("returningX"), tag.func_74762_e("returningY"), tag.func_74762_e("returningZ")), tag.func_74762_e("returningDimensionId"));
        }
        return custom;
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        super.writeToBuf(buf);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.offeringPlayerName);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.offeringPlayerId);
        if (this.providingPosition != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.providingPosition.func_177958_n());
            buf.writeInt(this.providingPosition.func_177956_o());
            buf.writeInt(this.providingPosition.func_177952_p());
            buf.writeInt(this.providingDimensionId);
        } else {
            buf.writeBoolean(false);
        }
        if (this.returningPosition != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.returningPosition.func_177958_n());
            buf.writeInt(this.returningPosition.func_177956_o());
            buf.writeInt(this.returningPosition.func_177952_p());
            buf.writeInt(this.returningDimensionId);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeInt(this.inStock);
        buf.writeInt(this.maxTrades);
        buf.writeInt(this.pendingPayments);
    }

    public static AmadronOfferCustom loadFromBuf(ByteBuf buf) {
        AmadronOfferCustom offer = new AmadronOfferCustom(PacketSyncAmadronOffers.readFluidOrItemStack(buf), PacketSyncAmadronOffers.readFluidOrItemStack(buf), ByteBufUtils.readUTF8String((ByteBuf)buf), ByteBufUtils.readUTF8String((ByteBuf)buf));
        if (buf.readBoolean()) {
            offer.setProvidingPosition(new BlockPos(buf.readInt(), buf.readInt(), buf.readInt()), buf.readInt());
        }
        if (buf.readBoolean()) {
            offer.setReturningPosition(new BlockPos(buf.readInt(), buf.readInt(), buf.readInt()), buf.readInt());
        }
        offer.inStock = buf.readInt();
        offer.maxTrades = buf.readInt();
        offer.pendingPayments = buf.readInt();
        return offer;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.addProperty("offeringPlayerName", this.offeringPlayerName);
        json.addProperty("offeringPlayerId", this.offeringPlayerId);
        json.addProperty("inStock", (Number)this.inStock);
        json.addProperty("maxTrades", (Number)this.maxTrades);
        json.addProperty("pendingPayments", (Number)this.pendingPayments);
        if (this.providingPosition != null) {
            json.addProperty("providingDimensionId", (Number)this.providingDimensionId);
            json.addProperty("providingX", (Number)this.providingPosition.func_177958_n());
            json.addProperty("providingY", (Number)this.providingPosition.func_177956_o());
            json.addProperty("providingZ", (Number)this.providingPosition.func_177952_p());
        }
        if (this.returningPosition != null) {
            json.addProperty("returningDimensionId", (Number)this.returningDimensionId);
            json.addProperty("returningX", (Number)this.returningPosition.func_177958_n());
            json.addProperty("returningY", (Number)this.returningPosition.func_177956_o());
            json.addProperty("returningZ", (Number)this.returningPosition.func_177952_p());
        }
        return json;
    }

    public static AmadronOfferCustom fromJson(JsonObject json) {
        AmadronOffer offer = AmadronOffer.fromJson(json);
        if (offer != null) {
            AmadronOfferCustom custom = new AmadronOfferCustom(offer.input, offer.output, json.get("offeringPlayerName").getAsString(), json.get("offeringPlayerId").getAsString());
            custom.inStock = json.get("inStock").getAsInt();
            custom.maxTrades = json.get("maxTrades").getAsInt();
            custom.pendingPayments = json.get("pendingPayments").getAsInt();
            if (json.has("providingDimensionId")) {
                custom.providingDimensionId = json.get("providingDimensionId").getAsInt();
                custom.providingPosition = new BlockPos(json.get("providingX").getAsInt(), json.get("providingY").getAsInt(), json.get("providingZ").getAsInt());
            }
            if (json.has("returningDimensionId")) {
                custom.returningDimensionId = json.get("returningDimensionId").getAsInt();
                custom.returningPosition = new BlockPos(json.get("returningX").getAsInt(), json.get("returningY").getAsInt(), json.get("returningZ").getAsInt());
            }
            return custom;
        }
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + " - " + this.offeringPlayerName;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof AmadronOfferCustom) {
            AmadronOfferCustom offer = (AmadronOfferCustom)o;
            return super.equals(o) && offer.offeringPlayerId.equals(this.offeringPlayerId);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.offeringPlayerId.hashCode();
    }
}

