/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.client.gui.GuiProgrammer;
import me.desht.pneumaticcraft.client.gui.programmer.GuiProgWidgetAreaShow;
import me.desht.pneumaticcraft.common.ai.DroneAIAttackEntity;
import me.desht.pneumaticcraft.common.ai.DroneAINearestAttackableTarget;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.progwidgets.EntityFilterPair;
import me.desht.pneumaticcraft.common.progwidgets.IAreaProvider;
import me.desht.pneumaticcraft.common.progwidgets.IEntityProvider;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetString;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaTypeBox;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ProgWidgetEntityAttack
extends ProgWidget
implements IAreaProvider,
IEntityProvider {
    private EntityFilterPair entityFilters;

    @Override
    public void addErrors(List<String> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.getConnectedParameters()[0] == null) {
            curInfo.add("gui.progWidget.area.error.noArea");
        }
        EntityFilterPair.addErrors(this, curInfo);
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public EntityAIBase getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return new DroneAIAttackEntity((EntityDrone)drone, 0.1, false);
    }

    @Override
    public EntityAIBase getWidgetTargetAI(IDroneBase drone, IProgWidget widget) {
        return new DroneAINearestAttackableTarget((EntityDrone)drone, 0, false, (ProgWidget)widget);
    }

    @Override
    public Class<? extends IProgWidget> returnType() {
        return null;
    }

    @Override
    public Class<? extends IProgWidget>[] getParameters() {
        return new Class[]{ProgWidgetArea.class, ProgWidgetString.class};
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_ATTACK;
    }

    @Override
    public String getWidgetString() {
        return "entityAttack";
    }

    @Override
    public List<Entity> getValidEntities(World world) {
        if (this.entityFilters == null) {
            this.entityFilters = new EntityFilterPair(this);
        }
        return this.entityFilters.getValidEntities(world);
    }

    @Override
    public boolean isEntityValid(Entity entity) {
        if (this.entityFilters == null) {
            this.entityFilters = new EntityFilterPair(this);
        }
        return this.entityFilters.isEntityValid(entity);
    }

    @Override
    public void getArea(Set<BlockPos> area) {
        ProgWidgetEntityAttack.getArea(area, (ProgWidgetArea)this.getConnectedParameters()[0], (ProgWidgetArea)this.getConnectedParameters()[2]);
    }

    public static void getArea(Set<BlockPos> area, ProgWidgetArea whitelistWidget, ProgWidgetArea blacklistWidget) {
        if (whitelistWidget == null) {
            return;
        }
        ProgWidgetArea widget = whitelistWidget;
        while (widget != null) {
            widget.getArea(area, new AreaTypeBox());
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        widget = blacklistWidget;
        while (widget != null) {
            HashSet<BlockPos> blacklistedArea = new HashSet<BlockPos>();
            widget.getArea(blacklistedArea, new AreaTypeBox());
            area.removeAll(blacklistedArea);
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiProgWidgetAreaShow<ProgWidgetEntityAttack>(this, guiProgrammer);
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public int getCraftingColorIndex() {
        return 1;
    }
}

