/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pressure;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirListener;
import me.desht.pneumaticcraft.api.tileentity.IPneumaticMachine;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.TileEntityCache;
import me.desht.pneumaticcraft.lib.EnumCustomParticleType;
import me.desht.pneumaticcraft.lib.Log;
import me.desht.pneumaticcraft.lib.Sounds;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class AirHandler
implements IAirHandler {
    private float maxPressure;
    @GuiSynced
    private int volume;
    private int defaultVolume;
    private final float dangerPressure;
    private final float criticalPressure;
    @GuiSynced
    private int air;
    private int soundCounter;
    private final Set<IAirHandler> specialConnectedHandlers = new HashSet<IAirHandler>();
    private TileEntityCache[] tileCache;
    private TileEntityBase.UpgradeCache upgradeCache;
    private IAirListener airListener;
    private IPneumaticMachine parentPneumatic;
    private World world;
    private BlockPos pos;

    AirHandler(float dangerPressure, float criticalPressure, int volume) {
        Validate.isTrue((volume > 0 ? 1 : 0) != 0, (String)"Volume can't be lower than or equal to 0!", (Object[])new Object[0]);
        this.dangerPressure = dangerPressure;
        this.criticalPressure = criticalPressure;
        this.maxPressure = dangerPressure + (criticalPressure - dangerPressure) * (float)Math.random();
        this.volume = volume;
        this.defaultVolume = volume;
    }

    public TileEntityCache[] getTileCache() {
        if (this.tileCache == null) {
            this.tileCache = TileEntityCache.getDefaultCache(this.getWorld(), this.getPos());
        }
        return this.tileCache;
    }

    @Override
    public void createConnection(@Nonnull IAirHandler otherHandler) {
        if (this.specialConnectedHandlers.add(otherHandler)) {
            otherHandler.createConnection(this);
        }
    }

    @Override
    public void removeConnection(@Nonnull IAirHandler otherHandler) {
        if (this.specialConnectedHandlers.remove(otherHandler)) {
            otherHandler.removeConnection(this);
        }
    }

    @Override
    public void printManometerMessage(EntityPlayer player, List<String> curInfo) {
        curInfo.add(TextFormatting.GREEN + "Current pressure: " + PneumaticCraftUtils.roundNumberTo(this.getPressure(), 1) + " bar.");
    }

    @Override
    public void update() {
        if (!this.getWorld().field_72995_K) {
            this.updateVolume();
            if (this.getUpgrades(IItemRegistry.EnumUpgrade.SECURITY) > 0) {
                this.doSecurityAirChecks();
            }
            if (this.getPressure() > this.maxPressure) {
                this.getWorld().func_72876_a(null, (double)this.getPos().func_177958_n() + 0.5, (double)this.getPos().func_177956_o() + 0.5, (double)this.getPos().func_177952_p() + 0.5, 1.0f, true);
                this.getWorld().func_175698_g(this.getPos());
            } else {
                this.disperseAir();
            }
        }
        if (this.soundCounter > 0) {
            --this.soundCounter;
        }
    }

    private void updateVolume() {
        this.setVolume(this.defaultVolume + this.getVolumeFromUpgrades());
    }

    private void doSecurityAirChecks() {
        int excessAir;
        if ((double)this.getPressure() >= (double)this.dangerPressure - 0.1) {
            this.airLeak(EnumFacing.UP);
        }
        if ((excessAir = this.getAir() - (int)((double)this.getVolume() * ((double)this.dangerPressure - 0.1))) > 0) {
            this.addAir(-excessAir);
            this.onAirDispersion(null, -excessAir);
        }
    }

    public void setVolume(int newVolume) {
        Validate.isTrue((newVolume > 0 ? 1 : 0) != 0, (String)"Volume can't be lower or equal than 0!", (Object[])new Object[0]);
        if (newVolume < this.volume) {
            this.air = (int)((float)this.air * (float)newVolume / (float)this.volume);
        }
        this.volume = newVolume;
    }

    private void onAirDispersion(EnumFacing dir, int airAdded) {
        if (this.airListener != null) {
            this.airListener.onAirDispersion(this, dir, airAdded);
        }
    }

    private int getMaxDispersion(EnumFacing dir) {
        return this.airListener != null ? this.airListener.getMaxDispersion(this, dir) : Integer.MAX_VALUE;
    }

    private int getUpgrades(IItemRegistry.EnumUpgrade upgrade) {
        return this.upgradeCache == null ? 0 : this.upgradeCache.getUpgrades(upgrade);
    }

    private int getVolumeFromUpgrades() {
        return this.getUpgrades(IItemRegistry.EnumUpgrade.VOLUME) * 5000;
    }

    private void disperseAir() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        this.disperseAir(this.getConnectedPneumatics());
    }

    private void disperseAir(List<Pair<EnumFacing, IAirHandler>> teList) {
        boolean shouldRepeat;
        ArrayList<MutablePair> dispersion = new ArrayList<MutablePair>();
        block0: do {
            shouldRepeat = false;
            int totalVolume = this.getVolume();
            int totalAir = this.air;
            for (Pair<EnumFacing, IAirHandler> pair : teList) {
                IAirHandler iAirHandler = (IAirHandler)pair.getValue();
                totalVolume += iAirHandler.getVolume();
                totalAir += iAirHandler.getAir();
            }
            Iterator<Object> iterator = teList.iterator();
            while (iterator.hasNext()) {
                Pair<EnumFacing, IAirHandler> pair = iterator.next();
                IAirHandler iAirHandler = (IAirHandler)pair.getValue();
                int totalMachineAir = (int)((long)totalAir * (long)iAirHandler.getVolume() / (long)totalVolume);
                int airDispersed = totalMachineAir - iAirHandler.getAir();
                if (airDispersed < 0) {
                    iterator.remove();
                    shouldRepeat = true;
                    dispersion.clear();
                    continue block0;
                }
                dispersion.add(new MutablePair((Object)this.getMaxDispersion((EnumFacing)pair.getKey()), (Object)airDispersed));
            }
        } while (shouldRepeat);
        int toBeDivided = 0;
        int receivers = dispersion.size();
        for (Pair pair : dispersion) {
            if ((Integer)pair.getValue() <= (Integer)pair.getKey()) continue;
            toBeDivided += (Integer)pair.getValue() - (Integer)pair.getKey();
            pair.setValue(pair.getKey());
            --receivers;
        }
        while (toBeDivided >= receivers && receivers > 0) {
            int dividedValue = toBeDivided / receivers;
            for (Pair pair : dispersion) {
                int maxTransfer = (Integer)pair.getKey() - (Integer)pair.getValue();
                if (maxTransfer > 0) {
                    if (maxTransfer <= dividedValue) {
                        --receivers;
                    }
                    int transfered = Math.min(dividedValue, maxTransfer);
                    pair.setValue((Object)((Integer)pair.getValue() + transfered));
                    toBeDivided -= transfered;
                    continue;
                }
                --receivers;
            }
        }
        for (int i = 0; i < teList.size(); ++i) {
            IAirHandler iAirHandler = (IAirHandler)teList.get(i).getValue();
            int n = (Integer)((Pair)dispersion.get(i)).getValue();
            this.onAirDispersion((EnumFacing)teList.get(i).getKey(), n);
            iAirHandler.addAir(n);
            this.addAir(-n);
        }
    }

    @Override
    public void addAir(int amount) {
        this.air = Math.max(this.air + amount, -this.volume);
    }

    @Override
    public void setDefaultVolume(int defaultVolume) {
        this.defaultVolume = defaultVolume;
    }

    @Override
    public float getPressure() {
        return (float)this.air / (float)this.volume;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        NBTTagCompound pneumaticTag = tag.func_74775_l("pneumatic");
        this.air = pneumaticTag.func_74762_e("air");
        this.maxPressure = pneumaticTag.func_74760_g("maxPressure");
        this.volume = pneumaticTag.func_74762_e("volume");
        if (this.volume == 0 && PneumaticCraftRepressurized.proxy.getClientWorld() == null) {
            Log.error("Volume was 0! Assigning default");
            this.volume = this.defaultVolume;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        NBTTagCompound pneumaticTag = new NBTTagCompound();
        pneumaticTag.func_74768_a("air", this.air);
        pneumaticTag.func_74768_a("volume", this.volume);
        pneumaticTag.func_74776_a("maxPressure", this.maxPressure);
        tag.func_74782_a("pneumatic", (NBTBase)pneumaticTag);
    }

    @Override
    public void validate(TileEntity parent) {
        this.upgradeCache = parent instanceof TileEntityBase ? ((TileEntityBase)parent).getUpgradeCache() : null;
        this.airListener = parent instanceof IAirListener ? (IAirListener)parent : null;
        this.parentPneumatic = (IPneumaticMachine)parent;
        this.setWorld(parent.func_145831_w());
        this.setPos(parent.func_174877_v());
    }

    @Override
    public void setPneumaticMachine(IPneumaticMachine machine) {
        this.parentPneumatic = machine;
    }

    @Override
    public void setAirListener(IAirListener airListener) {
        this.airListener = airListener;
    }

    @Override
    public void airLeak(EnumFacing side) {
        if (this.getWorld().field_72995_K || Math.abs(this.getPressure()) < 0.01f) {
            return;
        }
        double motionX = side.func_82601_c();
        double motionY = side.func_96559_d();
        double motionZ = side.func_82599_e();
        if (this.soundCounter <= 0) {
            float pitch = MathHelper.func_76131_a((float)(1.0f + (this.getPressure() - 3.0f) / 10.0f), (float)0.8f, (float)1.2f);
            this.soundCounter = (int)(20.0f / pitch);
            NetworkHandler.sendToAllAround(new PacketPlaySound(Sounds.LEAKING_GAS_SOUND, SoundCategory.BLOCKS, this.getPos().func_177958_n(), this.getPos().func_177956_o(), this.getPos().func_177952_p(), 0.1f, pitch, true), this.getWorld());
        }
        if (this.getPressure() < 0.0f) {
            double speed = this.getPressure() * 0.1f - 0.1f;
            NetworkHandler.sendToAllAround(new PacketSpawnParticle(EnumCustomParticleType.AIR_PARTICLE_DENSE, (double)this.getPos().func_177958_n() + 0.5 + motionX / 2.0, (double)this.getPos().func_177956_o() + 0.5 + motionY / 2.0, (double)this.getPos().func_177952_p() + 0.5 + motionZ / 2.0, motionX * speed, motionY * speed, motionZ * speed), this.getWorld());
            int dispersedAmount = -((int)(this.getPressure() * 40.0f)) + 20;
            if (this.getAir() > dispersedAmount) {
                dispersedAmount = -this.getAir();
            }
            this.onAirDispersion(side, dispersedAmount);
            this.addAir(dispersedAmount);
        } else {
            double speed = this.getPressure() * 0.1f + 0.1f;
            NetworkHandler.sendToAllAround(new PacketSpawnParticle(EnumCustomParticleType.AIR_PARTICLE_DENSE, (double)this.getPos().func_177958_n() + 0.5 + motionX / 2.0, (double)this.getPos().func_177956_o() + 0.5 + motionY / 2.0, (double)this.getPos().func_177952_p() + 0.5 + motionZ / 2.0, motionX * speed, motionY * speed, motionZ * speed), this.getWorld());
            int dispersedAmount = (int)(this.getPressure() * 40.0f) + 20;
            if (dispersedAmount > this.getAir()) {
                dispersedAmount = this.getAir();
            }
            this.onAirDispersion(side, -dispersedAmount);
            this.addAir(-dispersedAmount);
        }
    }

    @Override
    public List<Pair<EnumFacing, IAirHandler>> getConnectedPneumatics() {
        ArrayList<Pair<EnumFacing, IAirHandler>> teList = new ArrayList<Pair<EnumFacing, IAirHandler>>();
        for (IAirHandler specialConnection : this.specialConnectedHandlers) {
            teList.add((Pair<EnumFacing, IAirHandler>)new ImmutablePair(null, (Object)specialConnection));
        }
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            TileEntity te = this.getTileCache()[direction.ordinal()].getTileEntity();
            IPneumaticMachine machine = IPneumaticMachine.getMachine(te);
            if (machine == null || this.parentPneumatic.getAirHandler(direction) != this || machine.getAirHandler(direction.func_176734_d()) == null) continue;
            teList.add((Pair<EnumFacing, IAirHandler>)new ImmutablePair((Object)direction, (Object)machine.getAirHandler(direction.func_176734_d())));
        }
        if (this.airListener != null) {
            this.airListener.addConnectedPneumatics(teList);
        }
        return teList;
    }

    @Override
    public void onNeighborChange() {
        for (TileEntityCache cache : this.getTileCache()) {
            cache.update();
        }
    }

    @Override
    public int getVolume() {
        return this.volume;
    }

    @Override
    public float getMaxPressure() {
        return this.maxPressure;
    }

    @Override
    public float getDangerPressure() {
        return this.dangerPressure;
    }

    @Override
    public float getCriticalPressure() {
        return this.criticalPressure;
    }

    @Override
    public int getAir() {
        return this.air;
    }

    public void setAir(int air) {
        this.air = air;
    }

    public void setPressure(float pressure) {
        this.air = (int)(pressure * (float)this.volume);
    }

    @Override
    public void setUpgradeSlots(int ... upgradeSlots) {
    }

    @Override
    public int[] getUpgradeSlots() {
        return new int[0];
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public void setWorld(World world) {
        this.world = world;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public Set<Item> getApplicableUpgrades() {
        HashSet<Item> upgrades = new HashSet<Item>(2);
        upgrades.add(Itemss.upgrades.get(IItemRegistry.EnumUpgrade.VOLUME));
        upgrades.add(Itemss.upgrades.get(IItemRegistry.EnumUpgrade.SECURITY));
        return upgrades;
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException();
    }
}

