/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureTube;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;

public abstract class PacketUpdateTubeModule<REQ extends PacketUpdateTubeModule<REQ>>
extends LocationIntPacket<REQ> {
    protected EnumFacing moduleSide;

    public PacketUpdateTubeModule() {
    }

    public PacketUpdateTubeModule(TubeModule module) {
        super(module.getTube().pos());
        this.moduleSide = module.getDirection();
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeByte((int)((byte)this.moduleSide.ordinal()));
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.moduleSide = EnumFacing.func_82600_a((int)buffer.readByte());
    }

    @Override
    public void handleClientSide(REQ message, EntityPlayer player) {
        this.handleServerSide(message, player);
    }

    @Override
    public void handleServerSide(REQ message, EntityPlayer player) {
        TubeModule module;
        TileEntityPressureTube te = TileEntityPressureTube.getTube(((LocationIntPacket)message).getTileEntity(player.func_130014_f_()));
        if (te != null && (module = te.modules[((PacketUpdateTubeModule)message).moduleSide.ordinal()]) != null) {
            this.onModuleUpdate(module, message, player);
            if (!player.field_70170_p.field_72995_K) {
                NetworkHandler.sendToAllAround(message, player.field_70170_p);
            }
        }
    }

    protected abstract void onModuleUpdate(TubeModule var1, REQ var2, EntityPlayer var3);
}

