/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import me.desht.pneumaticcraft.common.inventory.ContainerLogistics;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockLogistics;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockManager;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockRequester;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;

public class PacketSetLogisticsMinAmounts
extends LocationIntPacket<PacketSetLogisticsMinAmounts> {
    private int minItems;
    private int minFluid;

    public PacketSetLogisticsMinAmounts() {
    }

    public PacketSetLogisticsMinAmounts(SemiBlockRequester logistics, int minItems, int minFluid) {
        super(logistics.getPos());
        this.minItems = minItems;
        this.minFluid = minFluid;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.minItems);
        buf.writeInt(this.minFluid);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.minItems = buf.readInt();
        this.minFluid = buf.readInt();
    }

    @Override
    public void handleClientSide(PacketSetLogisticsMinAmounts message, EntityPlayer player) {
    }

    @Override
    public void handleServerSide(PacketSetLogisticsMinAmounts message, EntityPlayer player) {
        if (message.pos.equals((Object)BlockPos.field_177992_a)) {
            if (player.field_71070_bA instanceof ContainerLogistics) {
                this.setMinAmounts(((ContainerLogistics)player.field_71070_bA).logistics, message.minItems, message.minFluid);
            }
        } else {
            SemiBlockLogistics semiBlock = SemiBlockManager.getInstance(player.field_70170_p).getSemiBlock(SemiBlockLogistics.class, player.field_70170_p, message.pos);
            this.setMinAmounts(semiBlock, message.minItems, message.minFluid);
        }
    }

    private void setMinAmounts(SemiBlockLogistics logistics, int minItems, int minFluid) {
        if (logistics instanceof SemiBlockRequester) {
            ((SemiBlockRequester)logistics).setMinItemOrderSize(minItems);
            ((SemiBlockRequester)logistics).setMinFluidOrderSize(minFluid);
        } else {
            Log.warning("Received PacketSetLogisticsMinAmounts for logistics @ " + logistics.getPos() + " but it is not a SemiBlockRequester!");
        }
    }
}

