/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.gui.areatool.GuiGPSAreaTool;
import me.desht.pneumaticcraft.common.item.ItemPneumatic;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.remote.GlobalVariableManager;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketHeldItemChange;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;

public class ItemGPSAreaTool
extends ItemPneumatic
implements IPositionProvider {
    public ItemGPSAreaTool() {
        super("gps_area_tool");
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND) {
            return EnumActionResult.PASS;
        }
        ItemGPSAreaTool.setGPSPosAndNotify(player, pos, 0);
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (handIn != EnumHand.MAIN_HAND) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
        }
        ItemStack stack = playerIn.func_184614_ca();
        if (worldIn.field_72995_K) {
            this.showGUI(stack, 0);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @SubscribeEvent
    public void onBlockLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getItemStack().func_77973_b() == this) {
            if (!event.getPos().equals((Object)ItemGPSAreaTool.getGPSLocation(event.getItemStack(), 1))) {
                ItemGPSAreaTool.setGPSPosAndNotify(event.getEntityPlayer(), event.getPos(), 1);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLeftClickAir(PlayerInteractEvent.LeftClickEmpty event) {
        if (event.getItemStack().func_77973_b() == this) {
            this.showGUI(event.getItemStack(), 1);
        }
    }

    public static void setGPSPosAndNotify(EntityPlayer player, BlockPos pos, int index) {
        ItemGPSAreaTool.setGPSLocation(player.func_184614_ca(), pos, index);
        if (!player.field_70170_p.field_72995_K) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.GREEN + String.format("[GPS Area Tool] Set P%d to %d, %d, %d.", index + 1, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())), false);
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketHeldItemChange(player.field_71071_by.field_70461_c));
            }
        }
    }

    private void showGUI(ItemStack stack, int index) {
        FMLCommonHandler.instance().showGuiScreen((Object)new GuiGPSAreaTool(stack, index));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> infoList, ITooltipFlag par4) {
        super.func_77624_a(stack, worldIn, infoList, par4);
        for (int index = 0; index < 2; ++index) {
            BlockPos pos = ItemGPSAreaTool.getGPSLocation(stack, index);
            infoList.add(String.format("\u00a72P%d: %d, %d, %d", index + 1, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
            String varName = ItemGPSAreaTool.getVariable(stack, index);
            if (varName.isEmpty()) continue;
            infoList.add(I18n.func_135052_a((String)"gui.tooltip.gpsTool.variable", (Object[])new Object[]{varName}));
        }
        ItemGPSAreaTool.getArea(stack).addAreaTypeTooltip(infoList);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean heldItem) {
        if (!world.field_72995_K) {
            for (int index = 0; index < 2; ++index) {
                String var = ItemGPSAreaTool.getVariable(stack, index);
                if (var.isEmpty()) continue;
                BlockPos pos = GlobalVariableManager.getInstance().getPos(var);
                ItemGPSAreaTool.setGPSLocation(stack, pos, index);
            }
        }
    }

    @Nonnull
    public static ProgWidgetArea getArea(ItemStack stack) {
        Validate.isTrue((boolean)(stack.func_77973_b() instanceof ItemGPSAreaTool));
        ProgWidgetArea area = new ProgWidgetArea();
        if (stack.func_77942_o()) {
            area.readFromNBT(stack.func_77978_p());
        }
        return area;
    }

    public static BlockPos getGPSLocation(ItemStack gpsTool, int index) {
        ProgWidgetArea area = ItemGPSAreaTool.getArea(gpsTool);
        String var = ItemGPSAreaTool.getVariable(gpsTool, index);
        if (!var.equals("") && PneumaticCraftRepressurized.proxy.getClientWorld() == null) {
            BlockPos pos = GlobalVariableManager.getInstance().getPos(var);
            ItemGPSAreaTool.setGPSLocation(gpsTool, pos, index);
        }
        if (index == 0) {
            return new BlockPos(area.x1, area.y1, area.z1);
        }
        if (index == 1) {
            return new BlockPos(area.x2, area.y2, area.z2);
        }
        throw new IllegalArgumentException("index must be 0 or 1!");
    }

    private static void setGPSLocation(ItemStack gpsTool, BlockPos pos, int index) {
        ProgWidgetArea area = ItemGPSAreaTool.getArea(gpsTool);
        if (index == 0) {
            area.setP1(pos);
        } else if (index == 1) {
            area.setP2(pos);
        }
        NBTUtil.initNBTTagCompound(gpsTool);
        area.writeToNBT(gpsTool.func_77978_p());
    }

    public static void setVariable(ItemStack gpsTool, String variable, int index) {
        ProgWidgetArea area = ItemGPSAreaTool.getArea(gpsTool);
        if (index == 0) {
            area.setCoord1Variable(variable);
        } else if (index == 1) {
            area.setCoord2Variable(variable);
        }
        NBTUtil.initNBTTagCompound(gpsTool);
        area.writeToNBT(gpsTool.func_77978_p());
    }

    public static String getVariable(ItemStack gpsTool, int index) {
        ProgWidgetArea area = ItemGPSAreaTool.getArea(gpsTool);
        return index == 0 ? area.getCoord1Variable() : area.getCoord2Variable();
    }

    @Override
    public List<BlockPos> getStoredPositions(@Nonnull ItemStack stack) {
        HashSet<BlockPos> posSet = new HashSet<BlockPos>();
        ItemGPSAreaTool.getArea(stack).getArea(posSet);
        return new ArrayList<BlockPos>(posSet);
    }

    @Override
    public int getRenderColor(int index) {
        return -1862271232;
    }

    @Override
    public boolean disableDepthTest() {
        return false;
    }
}

