/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.fluid;

import me.desht.pneumaticcraft.common.fluid.FluidPneumaticCraft;
import me.desht.pneumaticcraft.common.fluid.Fluids;
import net.minecraft.item.ItemDye;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class FluidPlastic
extends FluidPneumaticCraft {
    public FluidPlastic(String name) {
        super(name);
        this.setTemperature(423);
    }

    public int getColor(FluidStack plastic) {
        return FluidPlastic.getColorS(plastic);
    }

    public static int getColorS(FluidStack plastic) {
        return plastic.tag != null ? plastic.tag.func_74762_e("color") : 0xFFFFFF;
    }

    private static int[] getColor3(FluidStack plastic) {
        int color = FluidPlastic.getColorS(plastic);
        return new int[]{color >> 16, color >> 8 & 0xFF, color & 0xFF};
    }

    public int getTemperature(FluidStack plastic) {
        return 424;
    }

    public static void addDye(FluidStack plastic, int dyeMetadata) {
        if (!Fluids.areFluidsEqual(plastic.getFluid(), Fluids.PLASTIC)) {
            throw new IllegalArgumentException("Given fluid stack isn't mixable! " + plastic);
        }
        int dyeColor = ItemDye.field_150922_c[dyeMetadata];
        int[] dyeColors = new int[]{dyeColor >> 16, dyeColor >> 8 & 0xFF, dyeColor & 0xFF};
        int[] plasticColor = FluidPlastic.getColor3(plastic);
        double ratio = 0.2 / (0.2 * ((double)plastic.amount / 1000.0));
        for (int i = 0; i < 3; ++i) {
            plasticColor[i] = (int)(ratio * (double)dyeColors[i] + (1.0 - ratio) * (double)plasticColor[i]);
        }
        if (plastic.tag == null) {
            plastic.tag = new NBTTagCompound();
        }
        plastic.tag.func_74768_a("color", (plasticColor[0] << 16) + (plasticColor[1] << 8) + plasticColor[2]);
    }

    public static FluidStack mixFluid(FluidStack plastic, FluidStack otherPlastic) {
        if (plastic == null) {
            return otherPlastic;
        }
        if (otherPlastic == null) {
            return plastic;
        }
        int[] otherColor = FluidPlastic.getColor3(otherPlastic);
        int[] color = FluidPlastic.getColor3(plastic);
        double ratio = (double)plastic.amount / (double)(plastic.amount + otherPlastic.amount);
        int[] newColor = new int[3];
        for (int i = 0; i < 3; ++i) {
            newColor[i] = (int)(ratio * (double)color[i] + (1.0 - ratio) * (double)otherColor[i]);
        }
        NBTTagCompound newTag = new NBTTagCompound();
        newTag.func_74768_a("color", (newColor[0] << 16) + (newColor[1] << 8) + newColor[2]);
        return new FluidStack(Fluids.PLASTIC, plastic.amount + otherPlastic.amount, newTag);
    }
}

