/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.tubes;

import java.util.HashMap;
import java.util.List;
import java.util.OptionalInt;
import java.util.PriorityQueue;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.client.model.module.ModelLogistics;
import me.desht.pneumaticcraft.client.model.module.ModelModuleBase;
import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.ai.LogisticsManager;
import me.desht.pneumaticcraft.common.block.tubes.INetworkedModule;
import me.desht.pneumaticcraft.common.block.tubes.ModuleNetworkManager;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateLogisticModule;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockLogistics;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockManager;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.DyeUtils;

public class ModuleLogistics
extends TubeModule
implements INetworkedModule {
    private SemiBlockLogistics cachedFrame;
    private int colorChannel;
    private int ticksSinceAction = -1;
    private int ticksSinceNotEnoughAir = -1;
    private int ticksUntilNextCycle;
    private boolean powered;
    private static final double MIN_PRESSURE = 3.0;
    private static final double ITEM_TRANSPORT_COST = 2.5;
    private static final double FLUID_TRANSPORT_COST = 0.05;

    @SideOnly(value=Side.CLIENT)
    public int getTicksSinceAction() {
        return this.ticksSinceAction;
    }

    @SideOnly(value=Side.CLIENT)
    public int getTicksSinceNotEnoughAir() {
        return this.ticksSinceNotEnoughAir;
    }

    @Override
    public double getWidth() {
        return 0.8125;
    }

    @Override
    protected double getHeight() {
        return 0.28125;
    }

    @Override
    public String getType() {
        return "logistics_module";
    }

    @Override
    protected GuiHandler.EnumGuiId getGuiId() {
        return null;
    }

    @Override
    public Class<? extends ModelModuleBase> getModelClass() {
        return ModelLogistics.class;
    }

    @Override
    public int getColorChannel() {
        return this.colorChannel;
    }

    @Override
    public void setColorChannel(int colorChannel) {
        this.colorChannel = colorChannel;
    }

    public boolean hasPower() {
        return this.powered;
    }

    public void onUpdatePacket(int status, int colorChannel) {
        boolean bl = this.powered = status > 0;
        if (status == 2) {
            this.ticksSinceAction = 0;
        }
        if (status == 3) {
            this.ticksSinceNotEnoughAir = 0;
        }
        this.colorChannel = colorChannel;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74757_a("powered", this.powered);
        nbt.func_74774_a("colorChannel", (byte)this.colorChannel);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.powered = nbt.func_74767_n("powered");
        this.colorChannel = nbt.func_74771_c("colorChannel");
    }

    public SemiBlockLogistics getFrame() {
        if (this.cachedFrame == null) {
            this.cachedFrame = SemiBlockManager.getInstance(this.getTube().world()).getSemiBlock(SemiBlockLogistics.class, this.getTube().world(), this.getTube().pos().func_177972_a(this.dir));
        }
        return this.cachedFrame;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand) {
        OptionalInt colorIndex;
        ItemStack heldStack = player.func_184586_b(hand);
        if (!heldStack.func_190926_b() && (colorIndex = DyeUtils.dyeDamageFromStack((ItemStack)heldStack)).isPresent()) {
            if (!player.field_70170_p.field_72995_K) {
                this.setColorChannel(colorIndex.getAsInt());
                NetworkHandler.sendToAllAround(new PacketUpdateLogisticModule(this, 0), this.getTube().world());
                if (ConfigHandler.general.useUpDyesWhenColoring && !player.field_71075_bZ.field_75098_d) {
                    heldStack.func_190918_g(1);
                }
            }
            return true;
        }
        return super.onActivated(player, hand);
    }

    @Override
    public void update() {
        super.update();
        if (this.cachedFrame != null && this.cachedFrame.isInvalid()) {
            this.cachedFrame = null;
        }
        if (!this.getTube().world().field_72995_K) {
            if (this.powered != (double)this.getTube().getAirHandler(null).getPressure() >= 3.0) {
                this.powered = !this.powered;
                NetworkHandler.sendToAllAround(new PacketUpdateLogisticModule(this, 0), this.getTube().world());
            }
            if (--this.ticksUntilNextCycle <= 0) {
                LogisticsManager manager = new LogisticsManager();
                HashMap<SemiBlockLogistics, ModuleLogistics> frameToModuleMap = new HashMap<SemiBlockLogistics, ModuleLogistics>();
                HashMap<SemiBlockLogistics, EnumFacing> frameToSide = new HashMap<SemiBlockLogistics, EnumFacing>();
                for (TubeModule module : ModuleNetworkManager.getInstance(this.getTube().world()).getConnectedModules(this)) {
                    ModuleLogistics logistics;
                    if (!(module instanceof ModuleLogistics) || (logistics = (ModuleLogistics)module).getColorChannel() != this.getColorChannel()) continue;
                    logistics.ticksUntilNextCycle = 100;
                    if (!logistics.hasPower() || logistics.getFrame() == null) continue;
                    frameToSide.put(logistics.getFrame(), logistics.getFrame().getSide());
                    logistics.getFrame().setSide(logistics.dir.func_176734_d());
                    frameToModuleMap.put(logistics.getFrame(), logistics);
                    manager.addLogisticFrame(logistics.getFrame());
                }
                PriorityQueue<LogisticsManager.LogisticsTask> tasks = manager.getTasks(null);
                for (LogisticsManager.LogisticsTask task : tasks) {
                    if (!task.isStillValid(task.transportingItem.func_190926_b() ? task.transportingFluid.stack : task.transportingItem)) continue;
                    if (!task.transportingItem.func_190926_b()) {
                        this.handleItems((ModuleLogistics)frameToModuleMap.get(task.provider), (ModuleLogistics)frameToModuleMap.get(task.requester), task);
                        continue;
                    }
                    this.handleFluids((ModuleLogistics)frameToModuleMap.get(task.provider), (ModuleLogistics)frameToModuleMap.get(task.requester), task);
                }
                frameToSide.forEach(SemiBlockLogistics::setSide);
            }
        } else {
            if (this.ticksSinceAction >= 0) {
                ++this.ticksSinceAction;
                if (this.ticksSinceAction > 3) {
                    this.ticksSinceAction = -1;
                }
            }
            if (this.ticksSinceNotEnoughAir >= 0) {
                ++this.ticksSinceNotEnoughAir;
                if (this.ticksSinceNotEnoughAir > 20) {
                    this.ticksSinceNotEnoughAir = -1;
                }
            }
        }
    }

    private void handleItems(ModuleLogistics providingModule, ModuleLogistics requestingModule, LogisticsManager.LogisticsTask task) {
        IItemHandler requestingHandler = IOHelper.getInventoryForTE(task.requester.getTileEntity(), requestingModule.dir.func_176734_d());
        if (requestingHandler == null) {
            return;
        }
        ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)requestingHandler, (ItemStack)task.transportingItem, (boolean)true);
        if (remainder.func_190916_E() != task.transportingItem.func_190916_E()) {
            ItemStack toBeExtracted = task.transportingItem.func_77946_l();
            toBeExtracted.func_190918_g(remainder.func_190916_E());
            IItemHandler providingHandler = IOHelper.getInventoryForTE(task.provider.getTileEntity(), providingModule.dir.func_176734_d());
            ItemStack extractedStack = IOHelper.extract(providingHandler, toBeExtracted, IOHelper.ExtractCount.UP_TO, true, false);
            if (!extractedStack.func_190926_b()) {
                IAirHandler receiverAirHandler;
                int airUsed = (int)(2.5 * (double)extractedStack.func_190916_E() * PneumaticCraftUtils.distBetween((Vec3i)providingModule.getTube().pos(), (Vec3i)requestingModule.getTube().pos()));
                if (airUsed > (receiverAirHandler = requestingModule.getTube().getAirHandler(null)).getAir()) {
                    double scale = (double)receiverAirHandler.getAir() / (double)airUsed;
                    extractedStack.func_190920_e((int)((double)extractedStack.func_190916_E() * scale));
                    airUsed = (int)((double)airUsed * scale);
                }
                if (extractedStack.func_190926_b()) {
                    this.sendModuleUpdate(providingModule, false);
                    this.sendModuleUpdate(requestingModule, false);
                } else {
                    this.sendModuleUpdate(providingModule, true);
                    this.sendModuleUpdate(requestingModule, true);
                    receiverAirHandler.addAir(-airUsed);
                    IOHelper.extract(providingHandler, extractedStack, IOHelper.ExtractCount.EXACT, false, false);
                    ItemHandlerHelper.insertItem((IItemHandler)requestingHandler, (ItemStack)extractedStack, (boolean)false);
                    this.ticksUntilNextCycle = 20;
                }
            }
        }
    }

    private void handleFluids(ModuleLogistics providingModule, ModuleLogistics requestingModule, LogisticsManager.LogisticsTask task) {
        IFluidHandler requestingHandler = (IFluidHandler)task.requester.getTileEntity().getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, requestingModule.dir.func_176734_d());
        if (requestingHandler == null) {
            return;
        }
        int amountFilled = requestingHandler.fill(task.transportingFluid.stack, false);
        if (amountFilled > 0) {
            FluidStack extractedFluid;
            FluidStack drainingFluid = task.transportingFluid.stack.copy();
            drainingFluid.amount = amountFilled;
            IFluidHandler providingHandler = (IFluidHandler)task.provider.getTileEntity().getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, providingModule.dir.func_176734_d());
            if (providingHandler != null && (extractedFluid = providingHandler.drain(drainingFluid, false)) != null) {
                IAirHandler receiverAirHandler = requestingModule.getTube().getAirHandler(null);
                double airUsed = 0.05 * (double)extractedFluid.amount * PneumaticCraftUtils.distBetween((Vec3i)providingModule.getTube().pos(), (Vec3i)requestingModule.getTube().pos());
                if (airUsed > (double)receiverAirHandler.getAir()) {
                    double scale = (double)receiverAirHandler.getAir() / airUsed;
                    drainingFluid.amount = (int)((double)extractedFluid.amount * scale);
                    airUsed *= scale;
                }
                if (drainingFluid.amount == 0) {
                    this.sendModuleUpdate(providingModule, false);
                    this.sendModuleUpdate(requestingModule, false);
                } else {
                    this.sendModuleUpdate(providingModule, true);
                    this.sendModuleUpdate(requestingModule, true);
                    requestingModule.getTube().getAirHandler(null).addAir((int)(-airUsed));
                    requestingHandler.fill(providingHandler.drain(drainingFluid, true), true);
                    this.ticksUntilNextCycle = 20;
                }
            }
        }
    }

    private void sendModuleUpdate(ModuleLogistics module, boolean enoughAir) {
        NetworkHandler.sendToAllAround(new PacketUpdateLogisticModule(module, enoughAir ? 1 : 2), module.getTube().world());
    }

    @Override
    public void addInfo(List<String> curInfo) {
        super.addInfo(curInfo);
        String status = this.ticksSinceAction >= 0 ? "waila.logisticsModule.transporting" : (this.ticksSinceNotEnoughAir >= 0 ? "waila.logisticsModule.notEnoughAir" : (this.hasPower() ? "waila.logisticsModule.powered" : "waila.logisticsModule.noPower"));
        curInfo.add(PneumaticCraftUtils.xlate("hud.msg.state") + ": " + PneumaticCraftUtils.xlate(status));
    }

    @Override
    public boolean canUpgrade() {
        return false;
    }
}

