/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import me.desht.pneumaticcraft.common.ai.DroneAIBlockInteraction;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetPlace;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class DroneAIPlace
extends DroneAIBlockInteraction {
    public DroneAIPlace(IDroneBase drone, ProgWidgetAreaItemBase widget) {
        super(drone, widget);
    }

    @Override
    protected boolean respectClaims() {
        return true;
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        if (this.drone.world().func_180495_p(pos).func_185904_a().func_76222_j()) {
            boolean failedOnPlacement = false;
            for (int i = 0; i < this.drone.getInv().getSlots(); ++i) {
                ItemStack droneStack = this.drone.getInv().getStackInSlot(i);
                if (!(droneStack.func_77973_b() instanceof ItemBlock) || !this.widget.isItemValidForFilters(droneStack)) continue;
                Block placingBlock = ((ItemBlock)droneStack.func_77973_b()).func_179223_d();
                EnumFacing side = ProgWidgetPlace.getDirForSides(((ISidedWidget)((Object)this.widget)).getSides());
                if (this.drone.world().func_190527_a(placingBlock, pos, false, side, this.drone instanceof EntityDrone ? (EntityDrone)this.drone : null)) {
                    return true;
                }
                if (this.drone.world().func_190527_a(placingBlock, pos, true, side, this.drone instanceof EntityDrone ? (EntityDrone)this.drone : null)) {
                    this.drone.addDebugEntry("gui.progWidget.place.debug.cantPlaceBlock", pos);
                } else {
                    this.drone.addDebugEntry("gui.progWidget.place.debug.entityInWay", pos);
                }
                failedOnPlacement = true;
            }
            if (!failedOnPlacement) {
                this.abort();
            }
        }
        return false;
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double distToBlock) {
        if (this.drone.getPathNavigator().hasNoPath()) {
            EnumFacing side = ProgWidgetPlace.getDirForSides(((ISidedWidget)((Object)this.widget)).getSides());
            for (int i = 0; i < this.drone.getInv().getSlots(); ++i) {
                ItemStack droneStack = this.drone.getInv().getStackInSlot(i);
                if (!(droneStack.func_77973_b() instanceof ItemBlock) || !((ItemBlock)droneStack.func_77973_b()).func_179223_d().func_176198_a(this.drone.world(), pos, ProgWidgetPlace.getDirForSides(((ISidedWidget)((Object)this.widget)).getSides())) || !this.widget.isItemValidForFilters(droneStack)) continue;
                ItemBlock itemBlock = (ItemBlock)droneStack.func_77973_b();
                Block block = itemBlock.func_179223_d();
                if (!this.drone.world().func_190527_a(block, pos, false, side, this.drone instanceof EntityDrone ? (EntityDrone)this.drone : null)) continue;
                int newMeta = itemBlock.func_77647_b(droneStack.func_77960_j());
                this.setFakePlayerAccordingToDir();
                IBlockState iblockstate1 = block.getStateForPlacement(this.drone.world(), pos, side, (float)side.func_82601_c(), (float)side.func_96559_d(), (float)side.func_82599_e(), newMeta, (EntityLivingBase)this.drone.getFakePlayer(), EnumHand.MAIN_HAND);
                if (itemBlock.placeBlockAt(droneStack, (EntityPlayer)this.drone.getFakePlayer(), this.drone.world(), pos, side, (float)side.func_82601_c(), (float)side.func_96559_d(), (float)side.func_82599_e(), iblockstate1)) {
                    this.drone.addAir(null, -100);
                    SoundType soundType = block.getSoundType(iblockstate1, this.drone.world(), pos, (Entity)this.drone.getFakePlayer());
                    this.drone.world().func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f, false);
                    droneStack.func_190918_g(1);
                    if (droneStack.func_190916_E() <= 0) {
                        this.drone.getInv().setStackInSlot(i, ItemStack.field_190927_a);
                    }
                }
                return false;
            }
            return false;
        }
        return true;
    }

    private void setFakePlayerAccordingToDir() {
        EntityPlayerMP fakePlayer = this.drone.getFakePlayer();
        Vec3d pos = this.drone.getDronePos();
        fakePlayer.field_70165_t = pos.field_72450_a;
        fakePlayer.field_70161_v = pos.field_72449_c;
        switch (ProgWidgetPlace.getDirForSides(((ISidedWidget)((Object)this.widget)).getSides())) {
            case UP: {
                fakePlayer.field_70125_A = -90.0f;
                fakePlayer.field_70163_u = pos.field_72448_b - 10.0;
                return;
            }
            case DOWN: {
                fakePlayer.field_70125_A = 90.0f;
                fakePlayer.field_70163_u = pos.field_72448_b + 10.0;
                return;
            }
            case NORTH: {
                fakePlayer.field_70177_z = 180.0f;
                fakePlayer.field_70163_u = pos.field_72448_b;
                break;
            }
            case EAST: {
                fakePlayer.field_70177_z = 270.0f;
                fakePlayer.field_70163_u = pos.field_72448_b;
                break;
            }
            case SOUTH: {
                fakePlayer.field_70177_z = 0.0f;
                fakePlayer.field_70163_u = pos.field_72448_b;
                break;
            }
            case WEST: {
                fakePlayer.field_70177_z = 90.0f;
                fakePlayer.field_70163_u = pos.field_72448_b;
            }
        }
    }
}

