/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class TemporaryBlockManager
extends WorldSavedData {
    private static final Map<Integer, TemporaryBlockManager> managers = new HashMap<Integer, TemporaryBlockManager>();
    private static final String DATA_KEY = "PneumaticCraftTempBlocks";
    private final List<TempBlockRecord> tempBlocks = new ArrayList<TempBlockRecord>();
    private final int dimId;

    private TemporaryBlockManager(String dataKey, int dimId) {
        super(dataKey);
        this.dimId = dimId;
    }

    public static TemporaryBlockManager getManager(World world) {
        return managers.computeIfAbsent(world.field_73011_w.getDimension(), TemporaryBlockManager::create);
    }

    private static TemporaryBlockManager create(int dimId) {
        WorldServer world = DimensionManager.getWorld((int)dimId);
        if (world != null) {
            TemporaryBlockManager mgr = (TemporaryBlockManager)world.func_72943_a(TemporaryBlockManager.class, DATA_KEY);
            if (mgr == null) {
                mgr = new TemporaryBlockManager(DATA_KEY, dimId);
                world.func_72823_a(DATA_KEY, (WorldSavedData)mgr);
            }
            return mgr;
        }
        return null;
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        managers.remove(event.getWorld().field_73011_w.getDimension());
    }

    @SubscribeEvent
    public static void tickAll(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        for (Map.Entry<Integer, TemporaryBlockManager> entries : managers.entrySet()) {
            WorldServer world = DimensionManager.getWorld((int)entries.getKey());
            if (world == null) continue;
            Iterator<TempBlockRecord> iter = entries.getValue().tempBlocks.iterator();
            while (iter.hasNext()) {
                TempBlockRecord rec = iter.next();
                if (!world.func_175667_e(rec.pos) || rec.endTime > world.func_82737_E()) continue;
                if (world.func_180495_p(rec.pos) == rec.tempState) {
                    world.func_175718_b(2001, rec.pos, Block.func_176210_f((IBlockState)rec.tempState));
                    world.func_175656_a(rec.pos, rec.prevState);
                }
                iter.remove();
            }
        }
    }

    public void setBlock(BlockPos pos, IBlockState state, int durationTicks) {
        WorldServer world = DimensionManager.getWorld((int)this.dimId);
        if (world != null) {
            IBlockState prevState = world.func_180495_p(pos);
            world.func_175656_a(pos, state);
            this.tempBlocks.add(new TempBlockRecord(pos, prevState, state, world.func_82737_E() + (long)durationTicks));
        }
    }

    public boolean trySetBlock(EntityPlayer player, EnumFacing face, BlockPos pos, IBlockState state, int durationTicks) {
        WorldServer world = DimensionManager.getWorld((int)this.dimId);
        if (world != null) {
            IBlockState prevState = world.func_180495_p(pos);
            if (PneumaticCraftUtils.tryPlaceBlock((World)world, pos, player, face, state)) {
                this.tempBlocks.add(new TempBlockRecord(pos, prevState, state, world.func_82737_E() + (long)durationTicks));
                return true;
            }
        }
        return false;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.tempBlocks.clear();
        NBTTagList list = nbt.func_150295_c("tempBlocks", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            this.tempBlocks.add(TempBlockRecord.readFromNBT(tag));
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (TempBlockRecord record : this.tempBlocks) {
            NBTTagCompound tag = new NBTTagCompound();
            record.writeToNBT(tag);
            list.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("tempBlocks", (NBTBase)list);
        return compound;
    }

    private static class TempBlockRecord {
        final BlockPos pos;
        final IBlockState tempState;
        final IBlockState prevState;
        final long endTime;

        private TempBlockRecord(BlockPos pos, IBlockState prevState, IBlockState tempState, long endTime) {
            this.pos = pos;
            this.prevState = prevState;
            this.tempState = tempState;
            this.endTime = endTime;
        }

        static TempBlockRecord readFromNBT(NBTTagCompound tag) {
            BlockPos pos = NBTUtil.func_186861_c((NBTTagCompound)tag.func_74775_l("pos"));
            IBlockState prevState = NBTUtil.func_190008_d((NBTTagCompound)tag.func_74775_l("prevState"));
            IBlockState state = NBTUtil.func_190008_d((NBTTagCompound)tag.func_74775_l("tempState"));
            long endTime = tag.func_74763_f("endTime");
            return new TempBlockRecord(pos, prevState, state, endTime);
        }

        void writeToNBT(NBTTagCompound tag) {
            tag.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.pos));
            tag.func_74782_a("prevState", (NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)this.prevState));
            tag.func_74782_a("tempState", (NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)this.tempState));
            tag.func_74772_a("endTime", this.endTime);
        }
    }
}

