/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.model.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import me.desht.pneumaticcraft.common.item.ItemProgrammingPuzzle;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetStart;
import me.desht.pneumaticcraft.common.progwidgets.WidgetRegistrator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class ModelProgrammingPuzzle
implements IModel {
    private static final float NORTH_Z_BASE = 0.4685f;
    private static final float SOUTH_Z_BASE = 0.5315f;
    private static final IModel MODEL = new ModelProgrammingPuzzle();
    private final IProgWidget widget;

    private ModelProgrammingPuzzle() {
        this(new ProgWidgetStart());
    }

    private ModelProgrammingPuzzle(IProgWidget widget) {
        this.widget = widget;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getTextures() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (IProgWidget widget : WidgetRegistrator.registeredWidgets) {
            builder.add((Object)ModelProgrammingPuzzle.getWidgetTexture(widget));
        }
        return builder.build();
    }

    private static ResourceLocation getWidgetTexture(IProgWidget widget) {
        String resourcePath = widget.getTexture().toString();
        resourcePath = resourcePath.replace("textures/", "").replace(".png", "");
        return new ResourceLocation(resourcePath);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        Pair<Double, Double> maxUV = this.widget.getMaxUV();
        float scale = 1.0f / (float)Math.max((Double)maxUV.getLeft(), (Double)maxUV.getRight());
        float transX = 0.0f;
        float transY = -1.0f + ((Double)maxUV.getRight()).floatValue();
        TRSRTransformation transform = state.apply(Optional.empty()).orElse(TRSRTransformation.identity()).compose(new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), null, new Vector3f(scale, scale, 1.0f), null)).compose(new TRSRTransformation(new Vector3f(transX, transY, 0.0f), null, new Vector3f(1.0f, 1.0f, 1.0f), null));
        TextureAtlasSprite widgetSprite = bakedTextureGetter.apply(ModelProgrammingPuzzle.getWidgetTexture(this.widget));
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)ItemTextureQuadConverter.genQuad((VertexFormat)format, (TRSRTransformation)transform, (float)0.0f, (float)0.0f, (float)(16.0f * ((Double)maxUV.getLeft()).floatValue()), (float)(16.0f * ((Double)maxUV.getRight()).floatValue()), (float)0.4685f, (TextureAtlasSprite)widgetSprite, (EnumFacing)EnumFacing.NORTH, (int)-1, (int)-1)).add((Object)ItemTextureQuadConverter.genQuad((VertexFormat)format, (TRSRTransformation)transform, (float)0.0f, (float)0.0f, (float)(16.0f * ((Double)maxUV.getLeft()).floatValue()), (float)(16.0f * ((Double)maxUV.getRight()).floatValue()), (float)0.5315f, (TextureAtlasSprite)widgetSprite, (EnumFacing)EnumFacing.SOUTH, (int)-1, (int)-1));
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((IModelState)state);
        return new BakedProgrammingPuzzle(this, (ImmutableList<BakedQuad>)builder.build(), widgetSprite, format, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)Maps.immutableEnumMap((Map)transformMap), Maps.newHashMap());
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public IModel process(ImmutableMap<String, String> customData) {
        String progWidgetName = (String)customData.get((Object)"progWidget");
        IProgWidget widget = WidgetRegistrator.getWidgetFromName(progWidgetName);
        if (widget == null) {
            throw new IllegalStateException("Invalid widget: " + progWidgetName);
        }
        return new ModelProgrammingPuzzle(widget);
    }

    private static class PuzzleOverrideList
    extends ItemOverrideList {
        private final BakedProgrammingPuzzle puzzle;

        PuzzleOverrideList(List<ItemOverride> overridesIn, BakedProgrammingPuzzle puzzle) {
            super(overridesIn);
            this.puzzle = puzzle;
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            IProgWidget widget = ItemProgrammingPuzzle.getWidgetForPiece(stack);
            if (widget == null) {
                return originalModel;
            }
            String name = widget.getWidgetString();
            if (!this.puzzle.cache.containsKey(name)) {
                IModel model = this.puzzle.parent.process((ImmutableMap<String, String>)ImmutableMap.of((Object)"progWidget", (Object)name));
                Function<ResourceLocation, TextureAtlasSprite> textureGetter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                IBakedModel bakedModel = model.bake((IModelState)new SimpleModelState(this.puzzle.transforms), this.puzzle.format, textureGetter);
                this.puzzle.cache.put(name, bakedModel);
                return bakedModel;
            }
            return (IBakedModel)this.puzzle.cache.get(name);
        }
    }

    protected static class BakedProgrammingPuzzle
    implements IBakedModel {
        private final ModelProgrammingPuzzle parent;
        private final Map<String, IBakedModel> cache;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final ImmutableList<BakedQuad> quads;
        private final TextureAtlasSprite particle;
        private final VertexFormat format;
        private final PuzzleOverrideList overridesList;

        BakedProgrammingPuzzle(ModelProgrammingPuzzle parent, ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, Map<String, IBakedModel> cache) {
            this.quads = quads;
            this.particle = particle;
            this.format = format;
            this.parent = parent;
            this.transforms = transforms;
            this.cache = cache;
            this.overridesList = new PuzzleOverrideList(Collections.emptyList(), this);
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return this.quads;
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particle;
        }

        public ItemOverrideList func_188617_f() {
            return this.overridesList;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
        }
    }

    public static enum LoaderProgrammingPuzzle implements ICustomModelLoader
    {
        INSTANCE;


        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("pneumaticcraft") && modelLocation.func_110623_a().contains("programming_puzzle");
        }

        public IModel loadModel(ResourceLocation modelLocation) {
            return MODEL;
        }

        public void func_110549_a(IResourceManager resourceManager) {
        }
    }
}

