/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.tubemodule;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiButtonSpecial;
import me.desht.pneumaticcraft.client.gui.tubemodule.GuiTubeModule;
import me.desht.pneumaticcraft.client.gui.widget.GuiCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetComboBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextFieldNumber;
import me.desht.pneumaticcraft.common.block.tubes.ModuleRedstone;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncRedstoneModuleToServer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiRedstoneModule
extends GuiTubeModule {
    private WidgetComboBox comboBox;
    private WidgetLabel constLabel;
    private WidgetTextFieldNumber textField;
    private WidgetLabel otherColorLabel;
    private GuiButtonSpecial ourColorButton;
    private GuiButtonSpecial otherColorButton;
    private int ourColor;
    private int otherColor;
    private GuiCheckBox invertCheckBox;

    public GuiRedstoneModule(EntityPlayer player, int x, int y, int z) {
        super(player, x, y, z);
        this.ySize = 202;
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.GUI_WIDGET_OPTIONS;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        ModuleRedstone mr = (ModuleRedstone)this.module;
        this.ourColor = mr.getColorChannel();
        this.otherColor = mr.getOtherColor();
        this.addWidget(new WidgetLabel(this.guiLeft + this.xSize / 2, this.guiTop + 5, "Redstone Module").setAlignment(WidgetLabel.Alignment.CENTRE));
        WidgetLabel ourColorLabel = new WidgetLabel(this.guiLeft + 10, this.guiTop + 20, "Our Color");
        this.addWidget(ourColorLabel);
        WidgetLabel opLabel = new WidgetLabel(this.guiLeft + 10, this.guiTop + 40, "Operation");
        this.addWidget(opLabel);
        this.otherColorLabel = new WidgetLabel(this.guiLeft + 10, this.guiTop + 60, "Other Color");
        this.addWidget(this.otherColorLabel);
        this.constLabel = new WidgetLabel(this.guiLeft + 15, this.guiTop + 60, "Constant");
        this.addWidget(this.constLabel);
        int w = 0;
        for (WidgetLabel label : ImmutableList.of((Object)ourColorLabel, (Object)this.otherColorLabel, (Object)opLabel, (Object)this.constLabel)) {
            w = Math.max(label.getBounds().width, w);
        }
        int xBase = this.guiLeft + w + 15;
        this.ourColorButton = new GuiButtonSpecial(0, xBase, this.guiTop + 15, 20, 20, ""){

            @Override
            public void onMouseClicked(int mouseX, int mouseY, int button) {
                if (button == 0) {
                    if (--GuiRedstoneModule.this.ourColor < 0) {
                        GuiRedstoneModule.this.ourColor = 15;
                    }
                } else if (button == 1 && ++GuiRedstoneModule.this.ourColor > 15) {
                    GuiRedstoneModule.this.ourColor = 0;
                }
            }
        };
        this.addWidget(this.ourColorButton);
        ArrayList<String> ops = new ArrayList<String>();
        for (ModuleRedstone.Operation op : ModuleRedstone.Operation.values()) {
            ops.add(I18n.func_135052_a((String)op.getTranslationKey(), (Object[])new Object[0]));
        }
        this.comboBox = new WidgetComboBox(this.field_146289_q, xBase, this.guiTop + 39, this.xSize - xBase + this.guiLeft - 10, 12).setFixedOptions().setShouldSort(false).setElements(ops);
        this.comboBox.selectElement(mr.getOperation().ordinal());
        this.addWidget(this.comboBox);
        this.otherColorButton = new GuiButtonSpecial(0, xBase, this.guiTop + 55, 20, 20, ""){

            @Override
            public void onMouseClicked(int mouseX, int mouseY, int button) {
                if (GuiRedstoneModule.this.comboBox.func_146206_l()) {
                    return;
                }
                if (button == 0) {
                    if (--GuiRedstoneModule.this.otherColor < 0) {
                        GuiRedstoneModule.this.otherColor = 15;
                    }
                } else if (button == 1 && ++GuiRedstoneModule.this.otherColor > 15) {
                    GuiRedstoneModule.this.otherColor = 0;
                }
            }
        };
        this.addWidget(this.otherColorButton);
        this.textField = new WidgetTextFieldNumber(this.field_146289_q, xBase, this.guiTop + 58, 30, 12);
        this.textField.minValue = 0;
        this.textField.setDecimals(0);
        this.textField.setValue(mr.getConstantVal());
        this.addWidget(this.textField);
        this.invertCheckBox = new GuiCheckBox(1, this.guiLeft + 10, this.guiTop + 80, -12566464, "Invert Output?"){

            @Override
            public void onMouseClicked(int mouseX, int mouseY, int button) {
                if (GuiRedstoneModule.this.comboBox.func_146206_l()) {
                    return;
                }
                super.onMouseClicked(mouseX, mouseY, button);
            }
        };
        this.invertCheckBox.checked = mr.isInvert();
        this.invertCheckBox.setTooltip(I18n.func_135052_a((String)"gui.redstoneModule.invert.tooltip", (Object[])new Object[0]));
        this.addWidget(this.invertCheckBox);
        this.updateWidgetVisibility();
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.updateWidgetVisibility();
    }

    private void updateWidgetVisibility() {
        ModuleRedstone.Operation op = this.getSelectedOp();
        this.constLabel.visible = op.useConst();
        this.textField.func_146189_e(op.useConst());
        this.otherColorLabel.visible = op.useOtherColor();
        this.otherColorButton.field_146125_m = op.useOtherColor();
        this.otherColorButton.setVisible(op.useOtherColor());
        this.ourColorButton.setRenderStacks(new ItemStack(Blocks.field_192443_dR, 1, EnumDyeColor.func_176766_a((int)this.ourColor).func_176765_a()));
        this.otherColorButton.setRenderStacks(new ItemStack(Blocks.field_192443_dR, 1, EnumDyeColor.func_176766_a((int)this.otherColor).func_176765_a()));
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        ModuleRedstone.Operation op = this.getSelectedOp();
        String key = op.getTranslationKey() + ".tooltip";
        String s = op.useConst() ? I18n.func_135052_a((String)key, (Object[])new Object[]{PneumaticCraftUtils.dyeColorDesc(this.ourColor), this.textField.getValue()}) : (op.useOtherColor() ? I18n.func_135052_a((String)key, (Object[])new Object[]{PneumaticCraftUtils.dyeColorDesc(this.ourColor), PneumaticCraftUtils.dyeColorDesc(this.otherColor)}) : I18n.func_135052_a((String)key, (Object[])new Object[]{PneumaticCraftUtils.dyeColorDesc(this.ourColor)}));
        List<String> l = PneumaticCraftUtils.convertStringIntoList(s, 30);
        int yBase = this.guiTop + this.ySize - l.size() * this.field_146289_q.field_78288_b - 10;
        for (int i = 0; i < l.size(); ++i) {
            this.field_146289_q.func_78276_b(l.get(i), this.guiLeft + 10, yBase + i * this.field_146289_q.field_78288_b, -12566464);
        }
    }

    private ModuleRedstone.Operation getSelectedOp() {
        return ModuleRedstone.Operation.values()[this.comboBox.getSelectedElementIndex()];
    }

    public void func_146281_b() {
        super.func_146281_b();
        ((ModuleRedstone)this.module).setColorChannel(this.ourColor);
        ((ModuleRedstone)this.module).setInvert(this.invertCheckBox.checked);
        ((ModuleRedstone)this.module).setOperation(this.getSelectedOp(), this.otherColor, this.textField.getValue());
        NetworkHandler.sendToServer(new PacketSyncRedstoneModuleToServer((ModuleRedstone)this.module));
    }
}

