/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticScreenBase;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiHelmetMainScreen;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.GuiCheckBox;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.UpgradeRenderHandlerList;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.MainHelmetHandler;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.config.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiSlider;

public class GuiMoveStat
extends GuiPneumaticScreenBase {
    private final IGuiAnimatedStat movedStat;
    private final IUpgradeRenderHandler renderHandler;
    private boolean clicked = false;
    private final List<IGuiAnimatedStat> otherStats = new ArrayList<IGuiAnimatedStat>();
    private final List<String> helpText = new ArrayList<String>();
    private final ArmorHUDLayout.LayoutTypes layoutItem;
    private GuiCheckBox snapToGrid;
    private GuiSlider gridSlider;
    private static boolean snap = false;
    private static int gridSize = 4;

    GuiMoveStat(IUpgradeRenderHandler renderHandler, ArmorHUDLayout.LayoutTypes layoutItem) {
        this(renderHandler, layoutItem, renderHandler.getAnimatedStat());
    }

    GuiMoveStat(IUpgradeRenderHandler renderHandler, ArmorHUDLayout.LayoutTypes layoutItem, @Nonnull IGuiAnimatedStat movedStat) {
        this.movedStat = movedStat;
        this.renderHandler = renderHandler;
        this.layoutItem = layoutItem;
        movedStat.openWindow();
        CommonArmorHandler hudHandler = CommonArmorHandler.getHandlerForPlayer();
        for (EntityEquipmentSlot slot : UpgradeRenderHandlerList.ARMOR_SLOTS) {
            List<IUpgradeRenderHandler> renderHandlers = UpgradeRenderHandlerList.instance().getHandlersForSlot(slot);
            for (int i = 0; i < renderHandlers.size(); ++i) {
                IGuiAnimatedStat stat;
                IUpgradeRenderHandler upgradeRenderHandler = renderHandlers.get(i);
                if (!hudHandler.isUpgradeRendererInserted(slot, i) || !hudHandler.isUpgradeRendererEnabled(slot, i) || (stat = upgradeRenderHandler.getAnimatedStat()) == null || stat == movedStat) continue;
                this.otherStats.add(stat);
            }
        }
        MainHelmetHandler mainOptions = HUDHandler.instance().getSpecificRenderer(MainHelmetHandler.class);
        if (movedStat != mainOptions.testMessageStat) {
            mainOptions.testMessageStat = new GuiAnimatedStat(null, "Test Message, keep in mind messages can be long!", GuiAnimatedStat.StatIcon.NONE, 0x7000AA00, null, ArmorHUDLayout.INSTANCE.messageStat);
            mainOptions.testMessageStat.openWindow();
            this.otherStats.add(mainOptions.testMessageStat);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.snapToGrid = new GuiCheckBox(1, 10, this.field_146295_m * 3 / 5, 0xC0C0C0, "Snap To Grid");
        this.snapToGrid.x = (this.field_146294_l - this.snapToGrid.getBounds().width) / 2;
        this.snapToGrid.checked = snap;
        this.addWidget(this.snapToGrid);
        this.gridSlider = new GuiSlider(2, this.snapToGrid.x, this.snapToGrid.y + 12, this.snapToGrid.getBounds().width, 10, "", "", 1.0, 12.0, (double)gridSize, false, true);
        this.func_189646_b((GuiButton)this.gridSlider);
    }

    @Override
    protected ResourceLocation getTexture() {
        return null;
    }

    protected void func_146273_a(int x, int y, int lastButtonClicked, long timeSinceMouseClick) {
        if (this.clicked) {
            this.reposition(this.movedStat, x, y);
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.movedStat.getBounds().contains(mouseX, mouseY)) {
            if (mouseButton == 2) {
                this.movedStat.setLeftSided(!this.movedStat.isLeftSided());
                this.save();
            } else if (mouseButton < 2) {
                this.clicked = true;
                this.reposition(this.movedStat, mouseX, mouseY);
            }
        } else {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int mouseButton) {
        if (this.clicked) {
            if (mouseButton == 0 || mouseButton == 1) {
                this.reposition(this.movedStat, mouseX, mouseY);
            }
            this.save();
            this.clicked = false;
        }
        super.func_146286_b(mouseX, mouseY, mouseButton);
    }

    private void reposition(IGuiAnimatedStat stat, int x, int y) {
        if (snap) {
            x -= x % gridSize;
            y -= y % gridSize;
        }
        stat.setBaseX(x);
        stat.setBaseY(y);
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiHelmetMainScreen.getInstance());
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    @Override
    public void func_73863_a(int x, int y, float partialTicks) {
        this.func_146276_q_();
        GuiUtils.showPopupHelpScreen(this, this.field_146289_q, this.helpText);
        super.func_73863_a(x, y, partialTicks);
        this.movedStat.render(-1, -1, partialTicks);
        this.otherStats.forEach(stat -> {
            int c = stat.getBackgroundColor();
            stat.setBackGroundColor(0x30606060);
            stat.render(-1, -1, partialTicks);
            stat.setBackGroundColor(c);
        });
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        snap = this.snapToGrid.checked;
        gridSize = this.gridSlider.getValueInt();
        this.gridSlider.field_146125_m = snap;
        this.movedStat.update();
        this.otherStats.forEach(IGuiAnimatedStat::update);
        if (this.helpText.isEmpty()) {
            this.helpText.add(TextFormatting.GREEN + "" + TextFormatting.UNDERLINE + "Moving: " + I18n.func_135052_a((String)("pneumaticHelmet.upgrade." + this.renderHandler.getUpgradeName()), (Object[])new Object[0]));
            this.helpText.add("");
            this.helpText.add("Left- or Right-Click: move the highlighted stat");
            this.helpText.add("...");
        }
        this.helpText.set(3, "Stat expands " + this.getDir(this.movedStat.isLeftSided()) + ". Middle-click: expand " + this.getDir(!this.movedStat.isLeftSided()));
    }

    private String getDir(boolean left) {
        return TextFormatting.YELLOW + (left ? "Left" : "Right") + TextFormatting.RESET;
    }

    private void save() {
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        ArmorHUDLayout.INSTANCE.updateLayout(this.layoutItem, (float)((double)this.movedStat.getBaseX() / sr.func_78327_c()), (float)((double)this.movedStat.getBaseY() / sr.func_78324_d()), this.movedStat.isLeftSided());
    }
}

