/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.ClientTickHandler;
import me.desht.pneumaticcraft.client.gui.GuiSecurityStationBase;
import me.desht.pneumaticcraft.client.gui.INeedTickUpdate;
import me.desht.pneumaticcraft.client.render.RenderProgressingLine;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySecurityStation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;

public class NetworkConnectionHandler
implements INeedTickUpdate {
    protected final GuiSecurityStationBase gui;
    protected final TileEntitySecurityStation station;
    protected int baseX;
    protected int baseY;
    protected final int nodeSpacing;
    protected final int color;
    protected final List<RenderProgressingLine> lineList = new ArrayList<RenderProgressingLine>();
    protected final boolean[] slotHacked = new boolean[35];
    public final boolean[] slotFortified = new boolean[35];
    private final float baseBridgeSpeed;

    public NetworkConnectionHandler(GuiSecurityStationBase gui, TileEntitySecurityStation station, int baseX, int baseY, int nodeSpacing, int color, float baseBridgeSpeed) {
        this.gui = gui;
        this.station = station;
        this.baseX = baseX;
        this.baseY = baseY;
        this.nodeSpacing = nodeSpacing;
        this.color = color;
        this.baseBridgeSpeed = baseBridgeSpeed;
        ClientTickHandler.instance().registerUpdatedObject(this);
    }

    public NetworkConnectionHandler(NetworkConnectionHandler copy) {
        this(copy.gui, copy.station, copy.baseX, copy.baseY, copy.nodeSpacing, copy.color, copy.baseBridgeSpeed);
        for (int i = 0; i < this.slotHacked.length; ++i) {
            this.slotHacked[i] = copy.slotHacked[i];
            this.slotFortified[i] = copy.slotFortified[i];
        }
        for (RenderProgressingLine line : copy.lineList) {
            this.lineList.add(new RenderProgressingLine(line));
        }
    }

    public NetworkConnectionHandler(NetworkConnectionHandler copy, int baseX, int baseY) {
        this(copy);
        this.baseX = baseX;
        this.baseY = baseY;
        for (RenderProgressingLine line : this.lineList) {
            line.startX = line.startX - (double)copy.baseX + (double)baseX;
            line.startY = line.startY - (double)copy.baseY + (double)baseY;
            line.endX = line.endX - (double)copy.baseX + (double)baseX;
            line.endY = line.endY - (double)copy.baseY + (double)baseY;
        }
    }

    public void render() {
        float f = (float)(this.color >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(this.color & 0xFF) / 255.0f;
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)f1, (float)f2, (float)f3, (float)f);
        for (RenderProgressingLine line : this.lineList) {
            line.render();
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    @Override
    public void update() {
        for (RenderProgressingLine line : this.lineList) {
            int slot = line.getPointedSlotNumber(this.gui);
            ItemStack stack = this.station.getPrimaryInventory().getStackInSlot(slot);
            boolean done = line.incProgress(this.baseBridgeSpeed * (1.0f / (1.2f * (float)(stack.func_190926_b() ? 1 : stack.func_190916_E() + (this.slotFortified[slot] ? 1 : 0)))));
            if (!done || slot >= this.slotHacked.length) continue;
            if (!this.slotHacked[slot]) {
                this.onSlotHack(slot, false);
            }
            this.slotHacked[slot] = true;
        }
    }

    protected void onSlotHack(int slot, boolean nuked) {
    }

    protected void addConnection(int firstSlot, int secondSlot) {
        double startX = this.baseX + firstSlot % 5 * this.nodeSpacing;
        double startY = this.baseY + firstSlot / 5 * this.nodeSpacing;
        double endX = this.baseX + secondSlot % 5 * this.nodeSpacing;
        double endY = this.baseY + secondSlot / 5 * this.nodeSpacing;
        for (RenderProgressingLine line : this.lineList) {
            if (!line.hasLineSameProperties(startX, startY, 0.0, endX, endY, 0.0)) continue;
            return;
        }
        this.lineList.add(new RenderProgressingLine(startX, startY, endX, endY));
    }

    protected void removeConnection(int firstSlot, int secondSlot) {
        double startX = this.baseX + firstSlot % 5 * this.nodeSpacing;
        double startY = this.baseY + firstSlot / 5 * this.nodeSpacing;
        double endX = this.baseX + secondSlot % 5 * this.nodeSpacing;
        double endY = this.baseY + secondSlot / 5 * this.nodeSpacing;
        for (RenderProgressingLine line : this.lineList) {
            if (!line.hasLineSameProperties(startX, startY, 0.0, endX, endY, 0.0)) continue;
            this.lineList.remove(line);
            return;
        }
    }

    protected boolean tryToHackSlot(int slotNumber) {
        boolean successfullyHacked = false;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (!this.station.connects(slotNumber, slotNumber + i + j * 5) || !this.slotHacked[slotNumber + i + j * 5]) continue;
                this.addConnection(slotNumber + i + j * 5, slotNumber);
                successfullyHacked = true;
            }
        }
        return successfullyHacked;
    }

    public boolean canHackSlot(int slotNumber) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (!this.station.connects(slotNumber, slotNumber + i + j * 5) || !this.slotHacked[slotNumber + i + j * 5]) continue;
                return true;
            }
        }
        return false;
    }
}

