/*
 * Decompiled with CFR 0.152.
 */
package extracells.util.datafix;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import com.google.common.base.Preconditions;
import extracells.api.gas.IAEGasStack;
import extracells.api.gas.IGasStorageChannel;
import extracells.util.Log;
import extracells.util.StorageChannels;
import javax.annotation.Nonnull;
import mekanism.api.gas.GasStack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.fluids.FluidStack;

public class BasicCellDataFixer
implements IFixableData {
    public int func_188216_a() {
        return 4;
    }

    @Nonnull
    public NBTTagCompound func_188217_a(@Nonnull NBTTagCompound oldItem) {
        String id = oldItem.func_74779_i("id");
        if (!id.equalsIgnoreCase("extracells:storage.fluid") && !id.equalsIgnoreCase("extracells:storage.gas")) {
            return oldItem;
        }
        if (!oldItem.func_74764_b("tag") || oldItem.func_74775_l("tag").func_82582_d()) {
            return oldItem;
        }
        boolean isFluid = id.contains("fluid");
        boolean needsConvert = false;
        for (int i = 0; i < 5; ++i) {
            if (!oldItem.func_74775_l("tag").func_74764_b((isFluid ? "Fluid#" : "Gas#") + i)) continue;
            needsConvert = true;
        }
        if (!needsConvert) {
            return oldItem;
        }
        NBTTagCompound item = isFluid ? this.fixFluidCell(oldItem) : this.fixGasCell(oldItem);
        Log.info("Converted tag for {} cell from {} to {}", isFluid ? "fluid" : "gas", oldItem, item);
        return item;
    }

    protected NBTTagCompound fixFluidCell(NBTTagCompound oldItem) {
        NBTTagCompound item = oldItem.func_74737_b();
        NBTTagCompound tag = item.func_74775_l("tag");
        IFluidStorageChannel channel = StorageChannels.FLUID();
        ICellInventoryHandler cellInventory = AEApi.instance().registries().cell().getCellInventory(new ItemStack(item), null, (IStorageChannel)channel);
        Preconditions.checkNotNull((Object)cellInventory);
        for (int i = 0; i < 5; ++i) {
            if (!tag.func_74764_b("Fluid#" + i)) continue;
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("Fluid#" + i));
            Preconditions.checkNotNull((Object)fluidStack, (Object)("Failed to read FluidStack " + tag.func_74775_l("Fluid#" + i)));
            IAEFluidStack stack = (IAEFluidStack)channel.createStack((Object)fluidStack);
            if (stack == null) continue;
            cellInventory.injectItems((IAEStack)stack, Actionable.MODULATE, null);
            tag.func_82580_o("Fluid#" + i);
        }
        return item;
    }

    protected NBTTagCompound fixGasCell(NBTTagCompound oldItem) {
        NBTTagCompound item = oldItem.func_74737_b();
        NBTTagCompound tag = item.func_74775_l("tag");
        IGasStorageChannel channel = StorageChannels.GAS();
        ICellInventoryHandler cellInventory = AEApi.instance().registries().cell().getCellInventory(new ItemStack(item), null, (IStorageChannel)channel);
        Preconditions.checkNotNull((Object)cellInventory);
        for (int i = 0; i < 5; ++i) {
            if (!tag.func_74764_b("Gas#" + i)) continue;
            GasStack gasStack = GasStack.readFromNBT((NBTTagCompound)tag.func_74775_l("Gas#" + i));
            Preconditions.checkNotNull((Object)gasStack, (Object)("Failed to read GasStack " + tag.func_74775_l("Gas#" + i)));
            IAEGasStack stack = (IAEGasStack)channel.createStack(gasStack);
            if (stack == null) continue;
            cellInventory.injectItems((IAEStack)stack, Actionable.MODULATE, null);
            tag.func_82580_o("Gas#" + i);
        }
        return item;
    }
}

