/*
 * Decompiled with CFR 0.152.
 */
package extracells.util;

import appeng.api.config.SecurityPermissions;
import appeng.api.util.AEPartLocation;
import appeng.core.Api;
import extracells.api.IECTileEntity;
import extracells.container.ITickContainer;
import extracells.container.fluid.ContainerFluidStorage;
import extracells.container.gas.ContainerGasStorage;
import extracells.registries.BlockEnum;
import extracells.registries.ItemEnum;
import extracells.registries.PartEnum;
import extracells.util.PermissionUtil;
import extracells.util.TileUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ExtraCellsEventHandler {
    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        IECTileEntity tileEntity = TileUtil.getTile((IBlockAccess)event.getWorld(), event.getPos(), IECTileEntity.class);
        if (tileEntity != null && !PermissionUtil.hasPermission(event.getPlayer(), SecurityPermissions.BUILD, tileEntity.getGridNode(AEPartLocation.INTERNAL))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side == Side.SERVER && event.player != null && event.player.field_71070_bA != null) {
            Container con = event.player.field_71070_bA;
            if (con instanceof ContainerFluidStorage) {
                ((ContainerFluidStorage)con).removeEnergyTick();
            } else if (con instanceof ContainerGasStorage) {
                ((ContainerGasStorage)con).removeEnergyTick();
            }
            if (con instanceof ITickContainer) {
                ((ITickContainer)con).onTick();
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        List tooltip = event.getToolTip();
        String name = stack.func_77977_a();
        TextComponentTranslation text1 = new TextComponentTranslation("extracells.tooltip.deprecated1", new Object[0]);
        TextComponentTranslation text3 = new TextComponentTranslation("extracells.tooltip.deprecated.part", new Object[0]);
        Style style = new Style();
        style.func_150238_a(TextFormatting.RED);
        String ae2Name = "";
        boolean isDeprecated = false;
        if (BlockEnum.ECBASEBLOCK.getItem().func_77658_a().equalsIgnoreCase(name)) {
            ae2Name = ((Block)Api.INSTANCE.definitions().blocks().fluidIface().maybeBlock().get()).func_149732_F();
            isDeprecated = true;
        } else if (PartEnum.INTERFACE.getTranslationKey().equalsIgnoreCase(name)) {
            ae2Name = ((ItemStack)Api.INSTANCE.definitions().parts().fluidIface().maybeStack(1).get()).func_82833_r();
            isDeprecated = true;
        } else if (PartEnum.FLUIDIMPORT.getTranslationKey().equalsIgnoreCase(name)) {
            ae2Name = ((ItemStack)Api.INSTANCE.definitions().parts().fluidImportBus().maybeStack(1).get()).func_82833_r();
            isDeprecated = true;
        } else if (PartEnum.FLUIDEXPORT.getTranslationKey().equalsIgnoreCase(name)) {
            ae2Name = ((ItemStack)Api.INSTANCE.definitions().parts().fluidExportBus().maybeStack(1).get()).func_82833_r();
            isDeprecated = true;
        } else if (PartEnum.FLUIDTERMINAL.getTranslationKey().equalsIgnoreCase(name)) {
            ae2Name = ((ItemStack)Api.INSTANCE.definitions().parts().fluidTerminal().maybeStack(1).get()).func_82833_r();
            isDeprecated = true;
        } else if (PartEnum.FLUIDSTORAGE.getTranslationKey().equalsIgnoreCase(name)) {
            ae2Name = ((ItemStack)Api.INSTANCE.definitions().parts().fluidStorageBus().maybeStack(1).get()).func_82833_r();
            isDeprecated = true;
        } else if (ItemEnum.FLUIDSTORAGE.getItem().func_77658_a().equalsIgnoreCase(item.func_77658_a())) {
            if (stack.func_77952_i() >= 0 && stack.func_77952_i() < 4) {
                isDeprecated = true;
                text3 = new TextComponentTranslation("extracells.tooltip.deprecated.cell", new Object[0]);
                switch (stack.func_77952_i()) {
                    case 0: {
                        ae2Name = ((ItemStack)Api.INSTANCE.definitions().items().fluidCell1k().maybeStack(1).get()).func_82833_r();
                        break;
                    }
                    case 1: {
                        ae2Name = ((ItemStack)Api.INSTANCE.definitions().items().fluidCell4k().maybeStack(1).get()).func_82833_r();
                        break;
                    }
                    case 2: {
                        ae2Name = ((ItemStack)Api.INSTANCE.definitions().items().fluidCell16k().maybeStack(1).get()).func_82833_r();
                        break;
                    }
                    case 3: {
                        ae2Name = ((ItemStack)Api.INSTANCE.definitions().items().fluidCell64k().maybeStack(1).get()).func_82833_r();
                    }
                }
            }
        } else if (ItemEnum.STORAGECOMPONET.getItem().func_77658_a().equalsIgnoreCase(item.func_77658_a())) {
            if (stack.func_77952_i() >= 4 && stack.func_77952_i() < 8) {
                isDeprecated = true;
                switch (stack.func_77952_i()) {
                    case 4: {
                        ae2Name = ((ItemStack)Api.INSTANCE.definitions().materials().fluidCell1kPart().maybeStack(1).get()).func_82833_r();
                        break;
                    }
                    case 5: {
                        ae2Name = ((ItemStack)Api.INSTANCE.definitions().materials().fluidCell4kPart().maybeStack(1).get()).func_82833_r();
                        break;
                    }
                    case 6: {
                        ae2Name = ((ItemStack)Api.INSTANCE.definitions().materials().fluidCell16kPart().maybeStack(1).get()).func_82833_r();
                        break;
                    }
                    case 7: {
                        ae2Name = ((ItemStack)Api.INSTANCE.definitions().materials().fluidCell64kPart().maybeStack(1).get()).func_82833_r();
                    }
                }
            }
        } else if (PartEnum.FLUIDLEVELEMITTER.getTranslationKey().equalsIgnoreCase(name)) {
            ae2Name = ((ItemStack)Api.INSTANCE.definitions().parts().fluidLevelEmitter().maybeStack(1).get()).func_82833_r();
            isDeprecated = true;
        } else if (PartEnum.FLUIDPANEANNIHILATION.getTranslationKey().equalsIgnoreCase(name)) {
            ae2Name = ((ItemStack)Api.INSTANCE.definitions().parts().fluidAnnihilationPlane().maybeStack(1).get()).func_82833_r();
            isDeprecated = true;
        } else if (PartEnum.FLUIDPANEFORMATION.getTranslationKey().equalsIgnoreCase(name)) {
            ae2Name = ((ItemStack)Api.INSTANCE.definitions().parts().fluidFormationnPlane().maybeStack(1).get()).func_82833_r();
            isDeprecated = true;
        }
        if (isDeprecated) {
            text3.func_150255_a(style);
            tooltip.add(1, text3.func_150254_d());
            if (!ae2Name.isEmpty()) {
                TextComponentTranslation text2 = new TextComponentTranslation("extracells.tooltip.deprecated2", new Object[]{ae2Name});
                text2.func_150255_a(style);
                tooltip.add(1, text2.func_150254_d());
            }
            text1.func_150255_a(style);
            tooltip.add(1, text1.func_150254_d());
        }
    }
}

