/*
 * Decompiled with CFR 0.152.
 */
package extracells.part.fluid;

import appeng.api.config.Actionable;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.AECableType;
import extracells.models.PartModels;
import extracells.part.fluid.PartFluidIO;
import extracells.util.AEUtils;
import extracells.util.PermissionUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class PartFluidImport
extends PartFluidIO
implements IFluidHandler {
    public static final int AMOUNT_PER_TRANSFER = 125;

    @Override
    public float getCableConnectionLength(AECableType aeCableType) {
        return 5.0f;
    }

    @Override
    public boolean doWork(int rate, int TicksSinceLastCall) {
        if (this.getFacingTank() == null || !this.isActive()) {
            return false;
        }
        boolean empty = true;
        for (Fluid fluid : this.getActiveFilters()) {
            if (fluid == null) continue;
            empty = false;
            if (!this.fillToNetwork(fluid, rate * TicksSinceLastCall)) continue;
            return true;
        }
        return empty && this.fillToNetwork(null, rate * TicksSinceLastCall);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    public int fill(FluidStack resource, boolean doFill) {
        boolean redstonePowered = this.isRedstonePowered();
        if (resource == null || redstonePowered && this.getRedstoneMode() == RedstoneMode.LOW_SIGNAL || !redstonePowered && this.getRedstoneMode() == RedstoneMode.HIGH_SIGNAL) {
            return 0;
        }
        int drainAmount = Math.min(125 + this.speedState * 125, resource.amount);
        FluidStack toFill = new FluidStack(resource.getFluid(), drainAmount);
        Actionable action = doFill ? Actionable.MODULATE : Actionable.SIMULATE;
        IAEFluidStack filled = this.injectFluid(AEUtils.createFluidStack(toFill), action);
        if (filled == null) {
            return toFill.amount;
        }
        return toFill.amount - (int)filled.getStackSize();
    }

    protected boolean fillToNetwork(Fluid fluid, int toDrain) {
        IFluidHandler facingTank = this.getFacingTank();
        FluidStack drained = fluid == null ? facingTank.drain(toDrain, false) : facingTank.drain(new FluidStack(fluid, toDrain), false);
        if (drained == null || drained.amount <= 0 || drained.getFluid() == null) {
            return false;
        }
        IAEFluidStack toFill = AEUtils.createFluidStack(drained);
        IAEFluidStack notInjected = this.injectFluid(toFill, Actionable.MODULATE);
        if (notInjected != null) {
            int amount = (int)(toFill.getStackSize() - notInjected.getStackSize());
            if (amount > 0) {
                if (fluid == null) {
                    facingTank.drain(amount, true);
                } else {
                    facingTank.drain(new FluidStack(toFill.getFluid(), amount), true);
                }
                return true;
            }
            return false;
        }
        if (fluid == null) {
            facingTank.drain(toFill.getFluidStack().amount, true);
        } else {
            facingTank.drain(toFill.getFluidStack(), true);
        }
        return true;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 16.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
        bch.addBox(6.0, 6.0, 12.0, 10.0, 10.0, 13.0);
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 12.0);
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[0];
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand enumHand, Vec3d pos) {
        return PermissionUtil.hasPermission(player, SecurityPermissions.BUILD, this) && super.onActivate(player, enumHand, pos);
    }

    public <T> T getCapability(Capability<T> capabilityClass) {
        return (T)super.getCapability(capabilityClass);
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return PartModels.IMPORT_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return PartModels.IMPORT_ON;
        }
        return PartModels.IMPORT_OFF;
    }
}

