/*
 * Decompiled with CFR 0.152.
 */
package extracells.part.fluid;

import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.AECableType;
import extracells.models.PartModels;
import extracells.part.fluid.PartFluidIO;
import extracells.util.AEUtils;
import extracells.util.PermissionUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class PartFluidExport
extends PartFluidIO {
    @Override
    public float getCableConnectionLength(AECableType aeCableType) {
        return 5.0f;
    }

    @Override
    public boolean doWork(int rate, int TicksSinceLastCall) {
        IFluidHandler facingTank = this.getFacingTank();
        if (facingTank == null || !this.isActive()) {
            return false;
        }
        for (Fluid fluid : this.getActiveFilters()) {
            int filled;
            IAEFluidStack stack;
            if (fluid == null || (stack = this.extractFluid(AEUtils.createFluidStack(new FluidStack(fluid, rate * TicksSinceLastCall)), Actionable.SIMULATE)) == null || (filled = facingTank.fill(stack.getFluidStack(), true)) <= 0) continue;
            this.extractFluid(AEUtils.createFluidStack(new FluidStack(fluid, filled)), Actionable.MODULATE);
            return true;
        }
        return false;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(6.0, 6.0, 12.0, 10.0, 10.0, 13.0);
        bch.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox(6.0, 6.0, 15.0, 10.0, 10.0, 16.0);
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 12.0);
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (PermissionUtil.hasPermission(player, SecurityPermissions.BUILD, this)) {
            return super.onActivate(player, hand, pos);
        }
        return false;
    }

    public <T> T getCapability(Capability<T> capabilityClass) {
        return (T)super.getCapability(capabilityClass);
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return PartModels.EXPORT_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return PartModels.EXPORT_ON;
        }
        return PartModels.EXPORT_OFF;
    }
}

