/*
 * Decompiled with CFR 0.152.
 */
package extracells.models.drive;

import extracells.block.BlockHardMEDrive;
import extracells.block.properties.PropertyDrive;
import extracells.models.drive.DriveSlotState;
import extracells.models.drive.DriveSlotsState;
import extracells.models.drive.MatrixVertexTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class HardDriveBakedModel
implements IBakedModel {
    private final IBakedModel bakedBase;
    private final Map<DriveSlotState, IBakedModel> bakedCells;

    public HardDriveBakedModel(IBakedModel bakedBase, Map<DriveSlotState, IBakedModel> bakedCells) {
        this.bakedBase = bakedBase;
        this.bakedCells = bakedCells;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>();
        result.addAll(this.bakedBase.func_188616_a(state, side, rand));
        if (side == null && state instanceof IExtendedBlockState) {
            IExtendedBlockState extState = (IExtendedBlockState)state;
            DriveSlotsState slotsState = (DriveSlotsState)extState.getValue((IUnlistedProperty)PropertyDrive.INSTANCE);
            EnumFacing direction = (EnumFacing)extState.func_177229_b((IProperty)BlockHardMEDrive.FACING());
            if (slotsState == null) {
                return result;
            }
            for (int row = 0; row < 3; ++row) {
                DriveSlotState slotState = slotsState.getState(row);
                IBakedModel bakedCell = this.bakedCells.get((Object)slotState);
                Matrix4f transform = new Matrix4f();
                transform.setIdentity();
                float scale = 0.0625f;
                float yOffset = -3.0f * scale + (float)(-row * 3) * scale;
                switch (direction) {
                    case SOUTH: {
                        transform.setTranslation(new Vector3f(4.0f * scale, yOffset, 0.0f));
                        break;
                    }
                    case EAST: {
                        transform.setTranslation(new Vector3f(0.0f, yOffset, -4.0f * scale));
                        break;
                    }
                    case WEST: {
                        transform.setTranslation(new Vector3f(0.0f, yOffset, 4.0f * scale));
                        break;
                    }
                    default: {
                        transform.setTranslation(new Vector3f(-4.0f * scale, yOffset, 0.0f));
                    }
                }
                MatrixVertexTransformer transformer = new MatrixVertexTransformer(transform);
                for (BakedQuad bakedQuad : bakedCell.func_188616_a(state, null, rand)) {
                    UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(bakedQuad.getFormat());
                    transformer.setParent((IVertexConsumer)builder);
                    transformer.setVertexFormat(builder.getVertexFormat());
                    bakedQuad.pipe((IVertexConsumer)transformer);
                    result.add((BakedQuad)builder.build());
                }
            }
        }
        return result;
    }

    public boolean func_177555_b() {
        return this.bakedBase.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.bakedBase.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.bakedBase.func_177556_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.bakedBase.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.bakedBase.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return this.bakedBase.func_188617_f();
    }
}

