/*
 * Decompiled with CFR 0.152.
 */
package extracells.item.block;

import extracells.tileentity.TileEntityCertusTank;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockCertusTank
extends ItemBlock {
    public static final int CAPACITY = 32000;

    public ItemBlockCertusTank(Block block) {
        super(block);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerItemStack(stack, 32000);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List list, ITooltipFlag advanced) {
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
        if (fluidStack != null) {
            list.add(fluidStack.amount + "mB");
        }
    }

    public String func_77653_i(ItemStack itemStack) {
        if (itemStack != null) {
            FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)itemStack);
            if (fluidStack != null && fluidStack.getFluid() != null) {
                return I18n.func_74838_a((String)this.func_77667_c(itemStack)) + " - " + fluidStack.getFluid().getLocalizedName(fluidStack);
            }
            return I18n.func_74838_a((String)this.func_77667_c(itemStack));
        }
        return "";
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState)) {
            return false;
        }
        if (stack != null && stack.func_77942_o()) {
            TileEntityCertusTank certusTank = (TileEntityCertusTank)world.func_175625_s(pos);
            FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
            certusTank.setFluid(fluidStack);
        }
        return true;
    }
}

