/*
 * Decompiled with CFR 0.152.
 */
package extracells.integration.opencomputers;

import appeng.api.parts.IPartHost;
import appeng.api.util.AEPartLocation;
import extracells.integration.opencomputers.DriverBase;
import extracells.integration.opencomputers.OCUtils;
import extracells.part.PartOreDictExporter;
import extracells.registries.PartEnum;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import net.minecraft.tileentity.TileEntity;

public class DriverOreDictExportBus
extends DriverBase<PartOreDictExporter> {
    public DriverOreDictExportBus() {
        super(PartEnum.OREDICTEXPORTBUS, Enviroment.class);
    }

    @Override
    protected ManagedEnvironment createEnvironment(IPartHost host) {
        return new Enviroment(host);
    }

    public class Enviroment
    extends AbstractManagedEnvironment
    implements NamedBlock {
        protected final TileEntity tile;
        protected final IPartHost host;

        public Enviroment(IPartHost host) {
            this.tile = (TileEntity)host;
            this.host = host;
            this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent("me_exportbus").create());
        }

        @Callback(doc="function(side:number):string -- Get the configuration of the ore dict export bus pointing in the specified direction.")
        public Object[] getOreConfiguration(Context context, Arguments args) {
            AEPartLocation dir = AEPartLocation.fromOrdinal((int)args.checkInteger(0));
            if (dir == null || dir == AEPartLocation.INTERNAL) {
                return new Object[]{null, "unknown side"};
            }
            PartOreDictExporter part = (PartOreDictExporter)OCUtils.getPart(this.tile.func_145831_w(), this.tile.func_174877_v(), dir, PartOreDictExporter.class);
            if (part == null) {
                return new Object[]{null, "no export bus"};
            }
            return new Object[]{part.getFilter()};
        }

        @Callback(doc="function(side:number[, filter:string]):boolean -- Set the configuration of the ore dict export bus pointing in the specified direction.")
        public Object[] setOreConfiguration(Context context, Arguments args) {
            AEPartLocation dir = AEPartLocation.fromOrdinal((int)args.checkInteger(0));
            if (dir == null || dir == AEPartLocation.INTERNAL) {
                return new Object[]{null, "unknown side"};
            }
            PartOreDictExporter part = (PartOreDictExporter)OCUtils.getPart(this.tile.func_145831_w(), this.tile.func_174877_v(), dir, PartOreDictExporter.class);
            if (part == null) {
                return new Object[]{false, "no export bus"};
            }
            part.setFilter(args.optString(1, ""));
            context.pause(0.5);
            return new Object[]{true};
        }

        public String preferredName() {
            return "me_exportbus";
        }

        public int priority() {
            return 0;
        }
    }
}

