/*
 * Decompiled with CFR 0.152.
 */
package extracells.block;

import appeng.api.config.SecurityPermissions;
import extracells.api.IWrenchHandler;
import extracells.block.BlockEC;
import extracells.network.GuiHandler;
import extracells.tileentity.TileEntityFluidCrafter;
import extracells.util.PermissionUtil;
import extracells.util.TileUtil;
import extracells.util.WrenchUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class BlockFluidCrafter
extends BlockEC {
    public BlockFluidCrafter() {
        super(Material.field_151573_f, 2.0f, 10.0f);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.dropItems(world, pos);
        if (!world.field_72995_K) {
            TileUtil.destroy(world, pos);
        }
        super.func_180663_b(world, pos, state);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityFluidCrafter();
    }

    private void dropItems(World world, BlockPos pos) {
        Random rand = new Random();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof TileEntityFluidCrafter)) {
            return;
        }
        TileEntityFluidCrafter.FluidCrafterInventory inventory = ((TileEntityFluidCrafter)tileEntity).inventory;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            if (item == null || item.func_190916_E() <= 0) continue;
            float rx = rand.nextFloat() * 0.8f + 0.1f;
            float ry = rand.nextFloat() * 0.8f + 0.1f;
            float rz = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)pos.func_177958_n() + rx), (double)((float)pos.func_177956_o() + ry), (double)((float)pos.func_177952_p() + rz), item.func_77946_l());
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d(item.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            item.func_190920_e(0);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        ItemStack current = player.func_184586_b(hand);
        if (!player.func_70093_af()) {
            TileEntity tile = world.func_175625_s(pos);
            if (!PermissionUtil.hasPermission(player, SecurityPermissions.BUILD, tile)) {
                return false;
            }
            RayTraceResult rayTraceResult = new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), side, pos);
            IWrenchHandler wrenchHandler = WrenchUtil.getHandler(current, player, rayTraceResult, hand);
            if (wrenchHandler != null) {
                BlockFluidCrafter.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((Block)this));
                world.func_175698_g(pos);
                wrenchHandler.wrenchUsed(current, player, rayTraceResult, hand);
                return true;
            }
        }
        GuiHandler.launchGui(0, player, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        TileUtil.setOwner(world, pos, placer);
    }
}

