/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.isolator;

import binnie.core.genetics.Gene;
import binnie.core.machines.Machine;
import binnie.core.machines.MachineUtil;
import binnie.core.machines.errors.ErrorState;
import binnie.core.machines.errors.IErrorStateDefinition;
import binnie.core.machines.inventory.IChargedSlots;
import binnie.core.machines.power.ComponentProcessSetCost;
import binnie.core.machines.power.IProcess;
import binnie.genetics.config.ConfigurationMain;
import binnie.genetics.item.ItemSequence;
import binnie.genetics.machine.GeneticsErrorCode;
import binnie.genetics.machine.isolator.Isolator;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import java.util.Random;
import net.minecraft.item.ItemStack;

public class IsolatorLogic
extends ComponentProcessSetCost
implements IProcess {
    public static final float ENZYME_PER_PROCESS = 0.5f;
    public static final int ETHANOL_PER_PROCESS = 10;
    public static final float TARGET_LOSS_CHANCE = 0.05f;

    public IsolatorLogic(Machine machine) {
        super(machine, ConfigurationMain.isolatorEnergy, ConfigurationMain.isolatorTime);
    }

    @Override
    public ErrorState canWork() {
        if (this.getUtil().isSlotEmpty(5)) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.NO_INDIVIDUAL, 5);
        }
        if (!this.getUtil().isSlotEmpty(6)) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.ISOLATOR_NO_ROOM, Isolator.SLOT_FINISHED);
        }
        if (this.getUtil().isSlotEmpty(1)) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.ISOLATOR_NO_EMPTY_SEQUENCER, 1);
        }
        return super.canWork();
    }

    @Override
    public ErrorState canProgress() {
        if (!this.getUtil().liquidInTank(0, 10)) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.ISOLATOR_INSUFFICIENT_ETHANOL, 0);
        }
        if (this.getUtil().getSlotCharge(0) == 0.0f) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.NO_ENZYME, 0);
        }
        return super.canProgress();
    }

    @Override
    protected void onFinishTask() {
        super.onFinishTask();
        Random rand = this.getMachine().getWorld().field_73012_v;
        MachineUtil util = this.getUtil();
        ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(util.getStack(5));
        if (root == null) {
            return;
        }
        IIndividual individual = root.getMember(util.getStack(5));
        if (individual == null) {
            return;
        }
        IChromosomeType[] karyotype = root.getKaryotype();
        IChromosomeType chromosome = karyotype[rand.nextInt(karyotype.length)];
        IGenome genome = individual.getGenome();
        IAllele allele = rand.nextBoolean() ? genome.getActiveAllele(chromosome) : genome.getInactiveAllele(chromosome);
        Gene gene = Gene.create(allele, chromosome, root);
        ItemStack serum = ItemSequence.create(gene);
        util.setStack(6, serum);
        util.decreaseStack(1, 1);
        if (rand.nextFloat() < 0.05f) {
            util.decreaseStack(5, 1);
        }
        util.drainTank(0, 10);
    }

    @Override
    protected void onTickTask() {
        IChargedSlots chargedSlots = this.getMachine().getInterface(IChargedSlots.class);
        chargedSlots.alterCharge(0, -0.5f * this.getProgressPerTick() / 100.0f);
    }
}

