/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.models;

import binnie.extratrees.blocks.BlockETDefaultLeavesFruit;
import binnie.extratrees.blocks.property.PropertyETTypeFruit;
import binnie.extratrees.genetics.ETTreeDefinition;
import com.google.common.base.Preconditions;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ILeafSpriteProvider;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.core.IModelBaker;
import forestry.core.models.ModelBlockCached;
import forestry.core.models.baker.ModelBaker;
import forestry.core.proxy.Proxies;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelDefaultETLeavesFruit
extends ModelBlockCached<BlockETDefaultLeavesFruit, Key> {
    public ModelDefaultETLeavesFruit() {
        super(BlockETDefaultLeavesFruit.class);
    }

    protected Key getInventoryKey(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        Preconditions.checkArgument((boolean)(block instanceof BlockETDefaultLeavesFruit), (Object)"ItemStack must be for default fruit leaves.");
        BlockETDefaultLeavesFruit bBlock = (BlockETDefaultLeavesFruit)block;
        return new Key(bBlock.getTreeType((int)stack.func_77960_j()).definition, Proxies.render.fancyGraphicsEnabled());
    }

    protected Key getWorldKey(IBlockState state) {
        Block block = state.func_177230_c();
        Preconditions.checkArgument((boolean)(block instanceof BlockETDefaultLeavesFruit), (Object)"state must be for default fruit leaves.");
        BlockETDefaultLeavesFruit bBlock = (BlockETDefaultLeavesFruit)block;
        PropertyETTypeFruit.LeafVariant leafVariant = bBlock.getLeafVariant(state);
        Preconditions.checkNotNull((Object)leafVariant);
        return new Key(leafVariant.definition, Proxies.render.fancyGraphicsEnabled());
    }

    protected void bakeBlock(BlockETDefaultLeavesFruit block, Key key, IModelBaker baker, boolean inventory) {
        ETTreeDefinition treeDefinition = key.definition;
        TextureMap map = Minecraft.func_71410_x().func_147117_R();
        ITreeGenome genome = treeDefinition.getGenome();
        IAlleleTreeSpecies species = genome.getPrimary();
        ILeafSpriteProvider leafSpriteProvider = species.getLeafSpriteProvider();
        ResourceLocation leafSpriteLocation = leafSpriteProvider.getSprite(false, key.fancy);
        TextureAtlasSprite leafSprite = map.func_110572_b(leafSpriteLocation.toString());
        baker.addBlockModel(null, leafSprite, 0);
        ResourceLocation fruitSpriteLocation = genome.getFruitProvider().getDecorativeSprite();
        if (fruitSpriteLocation != null) {
            TextureAtlasSprite fruitSprite = map.func_110572_b(fruitSpriteLocation.toString());
            baker.addBlockModel(null, fruitSprite, 2);
        }
        baker.setParticleSprite(leafSprite);
    }

    protected IBakedModel bakeModel(IBlockState state, Key key, BlockETDefaultLeavesFruit block) {
        ModelBaker baker = new ModelBaker();
        this.bakeBlock(block, key, (IModelBaker)baker, false);
        this.blockModel = baker.bakeModel(false);
        this.onCreateModel(this.blockModel);
        return this.blockModel;
    }

    public static class Key {
        public final ETTreeDefinition definition;
        public final boolean fancy;
        private final int hashCode;

        public Key(ETTreeDefinition definition, boolean fancy) {
            this.definition = definition;
            this.fancy = fancy;
            this.hashCode = Objects.hash(new Object[]{definition, fancy});
        }

        public boolean equals(Object other) {
            if (!(other instanceof Key)) {
                return false;
            }
            Key otherKey = (Key)other;
            return otherKey.definition == this.definition && otherKey.fancy == this.fancy;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

