/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.gui.database;

import binnie.core.Binnie;
import binnie.core.api.genetics.IBreedingSystem;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.controls.ControlText;
import binnie.core.gui.database.ControlSpeciesBox;
import binnie.core.gui.database.DatabaseTab;
import binnie.core.gui.database.PageAbstract;
import binnie.core.gui.database.WindowAbstractDatabase;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.TextJustification;
import binnie.core.gui.minecraft.Window;
import binnie.extratrees.machines.lumbermill.recipes.LumbermillRecipeManager;
import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.ISpeciesRoot;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PagePlanksTrees
extends PageAbstract<ItemStack> {
    public PagePlanksTrees(IWidget parent, DatabaseTab tab) {
        super(parent, tab);
    }

    @Override
    public void onValueChanged(ItemStack species) {
        this.deleteAllChildren();
        WindowAbstractDatabase database = (WindowAbstractDatabase)Window.get(this);
        new ControlText(this, new Area(0, 0, this.getSize().xPos(), 24), species.func_82833_r(), TextJustification.MIDDLE_CENTER);
        Collection<IAlleleSpecies> trees = PagePlanksTrees.getTreesThatMakePlanks(species, database.isMaster(), database.getWorld(), database.getUsername());
        new ControlSpeciesBox(this, 4, 24, this.getSize().xPos() - 8, this.getSize().yPos() - 4 - 24).setOptions(trees);
    }

    private static Collection<IAlleleSpecies> getTreesThatMakePlanks(ItemStack fruit, boolean master, World world, GameProfile player) {
        if (fruit == null) {
            return new ArrayList<IAlleleSpecies>();
        }
        ITreeRoot treeRoot = TreeManager.treeRoot;
        IBreedingSystem system = Binnie.GENETICS.getSystem((ISpeciesRoot)treeRoot);
        Collection<IAlleleSpecies> set = master ? system.getAllSpecies() : system.getDiscoveredSpecies(world, player);
        ArrayList<IAlleleSpecies> found = new ArrayList<IAlleleSpecies>();
        for (IAlleleSpecies species : set) {
            IAlleleTreeSpecies tSpecies = (IAlleleTreeSpecies)species;
            ITreeGenome genome = treeRoot.templateAsGenome(treeRoot.getTemplate((IAlleleSpecies)tSpecies));
            IAlleleTreeSpecies treeSpecies = genome.getPrimary();
            ItemStack woodStack = treeSpecies.getWoodProvider().getWoodStack();
            ItemStack plankProduct = LumbermillRecipeManager.getPlankProduct(woodStack, world);
            if (plankProduct.func_190926_b() || !fruit.func_77969_a(plankProduct)) continue;
            found.add(species);
        }
        return found;
    }
}

