/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.genetics.gui.analyst;

import binnie.core.Binnie;
import binnie.core.api.genetics.IBreedingSystem;
import binnie.core.api.gui.IArea;
import binnie.core.api.gui.ITitledWidget;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.controls.ControlTextCentered;
import binnie.core.gui.controls.core.Control;
import binnie.core.util.I18N;
import binnie.core.util.TimeUtil;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import net.minecraft.util.text.TextFormatting;

public class AnalystPageGrowth
extends Control
implements ITitledWidget {
    public AnalystPageGrowth(IWidget parent, IArea area, IIndividual ind) {
        super(parent, area);
        this.setColor(0x333333);
        int y = 4;
        IAlleleSpecies species = ind.getGenome().getPrimary();
        new ControlTextCentered((IWidget)this, y, TextFormatting.UNDERLINE + this.getTitle()).setColor(this.getColor());
        y += 12;
        if (ind instanceof ITree) {
            ITree tree = (ITree)ind;
            int mat = tree.getGenome().getMaturationTime();
            new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.growth.mature")).setColor(this.getColor());
            new ControlTextCentered((IWidget)this, y += 12, TextFormatting.BOLD + TimeUtil.getTimeString(Math.round(1373.3999f * (float)mat))).setColor(this.getColor());
            IBreedingSystem treeSystem = Binnie.GENETICS.getSystem((ISpeciesRoot)TreeManager.treeRoot);
            new ControlTextCentered((IWidget)this, y += 22, TextFormatting.ITALIC + I18N.localise("genetics.gui.analyst.growth.height") + ": " + treeSystem.getAlleleName((IChromosomeType)EnumTreeChromosome.HEIGHT, ind.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.HEIGHT))).setColor(this.getColor());
            new ControlTextCentered((IWidget)this, y += 12, TextFormatting.ITALIC + I18N.localise("genetics.gui.analyst.growth.girth") + ": " + treeSystem.getAlleleName((IChromosomeType)EnumTreeChromosome.GIRTH, ind.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.GIRTH))).setColor(this.getColor());
        }
    }

    @Override
    public String getTitle() {
        return I18N.localise("genetics.gui.analyst.growth.title");
    }
}

