/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.worldgen;

import binnie.extrabees.blocks.BlockExtraBeeHives;
import binnie.extrabees.blocks.type.EnumHiveType;
import binnie.extrabees.genetics.ExtraBeeDefinition;
import binnie.extrabees.modules.ModuleCore;
import binnie.extrabees.utils.config.ConfigurationMain;
import binnie.extrabees.worldgen.WorldGenHiveMarble;
import binnie.extrabees.worldgen.WorldGenHiveNether;
import binnie.extrabees.worldgen.WorldGenHiveRock;
import binnie.extrabees.worldgen.WorldGenHiveWater;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.hives.IHiveDescription;
import forestry.api.apiculture.hives.IHiveGen;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public enum BinnieHiveDescription implements IHiveDescription
{
    WATER(EnumHiveType.WATER, ConfigurationMain.getWaterHiveRate(), ExtraBeeDefinition.WATER, new WorldGenHiveWater()),
    MARBLE(EnumHiveType.MARBLE, ConfigurationMain.getMarbleHiveRate() * 10.0f, ExtraBeeDefinition.MARBLE, new WorldGenHiveMarble()),
    ROCK(EnumHiveType.ROCK, ConfigurationMain.getRockHiveRate() * 3.0f, ExtraBeeDefinition.ROCK, new WorldGenHiveRock()),
    NETHER(EnumHiveType.NETHER, ConfigurationMain.getNetherHiveRate() * 3.0f, ExtraBeeDefinition.BASALT, new WorldGenHiveNether());

    private final EnumHiveType hiveType;
    private final float genChance;
    private final IBeeGenome genome;
    private final IHiveGen hiveGen;

    private BinnieHiveDescription(EnumHiveType hiveType, float genChance, ExtraBeeDefinition beeDefinition, IHiveGen hiveGen) {
        this.hiveType = hiveType;
        this.genChance = genChance;
        this.genome = beeDefinition.getGenome();
        this.hiveGen = hiveGen;
    }

    public IHiveGen getHiveGen() {
        return this.hiveGen;
    }

    public IBlockState getBlockState() {
        return ModuleCore.hive.func_176223_P().func_177226_a(BlockExtraBeeHives.HIVE_TYPE, (Comparable)((Object)this.hiveType));
    }

    public boolean isGoodBiome(Biome biome) {
        return this.hiveType != EnumHiveType.NETHER || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER);
    }

    public boolean isGoodHumidity(EnumHumidity humidity) {
        EnumHumidity idealHumidity = this.genome.getPrimary().getHumidity();
        EnumTolerance humidityTolerance = this.genome.getToleranceHumid();
        return AlleleManager.climateHelper.isWithinLimits(humidity, idealHumidity, humidityTolerance);
    }

    public boolean isGoodTemperature(EnumTemperature temperature) {
        EnumTemperature idealTemperature = this.genome.getPrimary().getTemperature();
        EnumTolerance temperatureTolerance = this.genome.getToleranceTemp();
        return AlleleManager.climateHelper.isWithinLimits(temperature, idealTemperature, temperatureTolerance);
    }

    public float getGenChance() {
        return this.genChance;
    }

    public String getName() {
        return this.hiveType.func_176610_l();
    }

    public void postGen(World world, Random random, BlockPos pos) {
    }
}

