/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.machines.mutator.window;

import binnie.core.gui.controls.ControlText;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.TextJustification;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.minecraft.control.ControlItemDisplay;
import binnie.core.gui.minecraft.control.ControlPlayerInventory;
import binnie.core.gui.minecraft.control.ControlSlot;
import binnie.core.machines.Machine;
import binnie.extrabees.utils.AlvearyMutationHandler;
import java.text.NumberFormat;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;

public class WindowAlvearyMutator
extends Window {
    public WindowAlvearyMutator(EntityPlayer player, IInventory inventory, Side side) {
        super(176, 176, player, inventory, side);
    }

    @Nullable
    public static Window create(EntityPlayer player, @Nullable IInventory inventory, Side side) {
        if (inventory == null) {
            return null;
        }
        return new WindowAlvearyMutator(player, inventory, side);
    }

    @Override
    public void initialiseClient() {
        this.setTitle(Machine.getMachine(this.getInventory()).getPackage().getDisplayName());
        new ControlPlayerInventory(this);
        new ControlSlot.Builder(this, 79, 30).assign(0);
        new ControlText(this, new Area(0, 52, this.getWidth(), 16), "Possible Mutagens:", TextJustification.MIDDLE_CENTER).setColor(0x555555);
        int size = AlvearyMutationHandler.getMutagens().size();
        int w = size * 18;
        NumberFormat numberFormat = NumberFormat.getNumberInstance(MinecraftForgeClient.getLocale());
        if (size > 0) {
            int x = (this.getWidth() - w) / 2;
            for (Pair<ItemStack, Float> mutagen : AlvearyMutationHandler.getMutagens()) {
                ControlItemDisplay display = new ControlItemDisplay(this, x, 66);
                display.setItemStack((ItemStack)mutagen.getKey());
                display.setTooltip();
                Float multiplier = (Float)mutagen.getValue();
                String format = numberFormat.format(multiplier);
                display.addTooltip(TextFormatting.GRAY + "Multiplier: " + format + "x");
                x += 18;
            }
        }
    }

    @Override
    protected String getModId() {
        return "extrabees";
    }

    @Override
    public String getBackgroundTextureName() {
        return "AlvearyMutator";
    }
}

