/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

import binnie.core.machines.IMachine;
import binnie.core.machines.inventory.BaseSlot;
import binnie.core.machines.inventory.ComponentInventory;
import binnie.core.machines.inventory.FakeSlot;
import binnie.core.machines.inventory.IInventoryMachine;
import binnie.core.machines.inventory.IInventorySlots;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.util.NBTUtil;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class ComponentInventorySlots
extends ComponentInventory
implements IInventoryMachine,
IInventorySlots {
    private static final String INVENTORY_KEY = "inventory";
    private static final String INDEX_KEY = "id";
    private static final float ACCEL = 0.05f;
    private final Map<Integer, InventorySlot> inventory = new LinkedHashMap<Integer, InventorySlot>();
    private final Map<EnumFacing, int[]> slotsForFace = new LinkedHashMap<EnumFacing, int[]>();

    public ComponentInventorySlots(IMachine machine) {
        super(machine);
    }

    @Override
    public ItemStack func_70304_b(int index) {
        InventorySlot slot = this.getInternalSlot(index);
        if (slot.isFake()) {
            return ItemStack.field_190927_a;
        }
        ItemStack content = slot.getItemStack();
        slot.setContent(ItemStack.field_190927_a);
        this.func_70296_d();
        return content;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString("");
    }

    @Override
    public int func_70302_i_() {
        int size = 0;
        for (int index : this.inventory.keySet()) {
            size = Math.max(size, index + 1);
        }
        return size;
    }

    @Override
    public ItemStack func_70301_a(int index) {
        if (this.inventory.containsKey(index)) {
            return this.inventory.get(index).getItemStack();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack func_70298_a(int index, int amount) {
        InventorySlot slot = this.getInternalSlot(index);
        ItemStack stack = slot.decrStackSize(amount);
        if (!stack.func_190926_b()) {
            this.func_70296_d();
        }
        return stack;
    }

    @Override
    public void func_70299_a(int index, ItemStack itemStack) {
        InventorySlot slot = this.getInternalSlot(index);
        if (!slot.isFake() && (itemStack.func_190926_b() || slot.isValid(itemStack))) {
            slot.setContent(itemStack);
            this.func_70296_d();
        }
    }

    @Override
    public boolean func_191420_l() {
        return this.inventory.isEmpty();
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        NBTUtil.readFromList(compound, INVENTORY_KEY, slotNBT -> {
            int index = slotNBT.func_74762_e(INDEX_KEY);
            InventorySlot slot = this.getInternalSlot(index);
            slot.readFromNBT((NBTTagCompound)slotNBT);
        });
        this.func_70296_d();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound = super.writeToNBT(compound);
        NBTUtil.writeToList(compound, INVENTORY_KEY, this.inventory, (index, slot) -> {
            NBTTagCompound slotTag = new NBTTagCompound();
            slotTag.func_74768_a(INDEX_KEY, index.intValue());
            slot.writeToNBT(slotTag);
            return slotTag;
        });
        return compound;
    }

    public final InventorySlot addSlot(int index, ResourceLocation unlocLocation) {
        InventorySlot slot = new InventorySlot(index, unlocLocation);
        this.inventory.put(index, slot);
        return slot;
    }

    @Deprecated
    public final InventorySlot addSlot(int index, String unlocName) {
        ResourceLocation unlocLocation = new ResourceLocation("binniecore", "gui.slot." + unlocName);
        return this.addSlot(index, unlocLocation);
    }

    public final InventorySlot[] addSlotArray(int[] indexes, ResourceLocation unlocalizedName) {
        return (InventorySlot[])Arrays.stream(indexes).mapToObj(index -> this.addSlot(index, unlocalizedName)).toArray(InventorySlot[]::new);
    }

    @Deprecated
    public final InventorySlot[] addSlotArray(int[] indexes, String unlocalizedName) {
        return (InventorySlot[])Arrays.stream(indexes).mapToObj(index -> this.addSlot(index, unlocalizedName)).toArray(InventorySlot[]::new);
    }

    @Override
    @Nullable
    public InventorySlot getSlot(int index) {
        if (this.inventory.containsKey(index)) {
            return this.inventory.get(index);
        }
        return null;
    }

    private InventorySlot getInternalSlot(int index) {
        return this.inventory.getOrDefault(index, FakeSlot.INSTANCE);
    }

    private boolean isReadOnly(int slot) {
        InventorySlot iSlot = this.getSlot(slot);
        return iSlot == null || iSlot.isReadOnly();
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack itemStack) {
        InventorySlot slot = this.getSlot(index);
        return slot != null && slot.isValid(itemStack) && !this.isReadOnly(index);
    }

    @Override
    public void onDestruction() {
        IMachine machine = this.getMachine();
        World world = machine.getWorld();
        Random rand = world.field_73012_v;
        BlockPos pos = machine.getTileEntity().func_174877_v();
        for (InventorySlot slot : this.inventory.values()) {
            ItemStack stack = slot.getItemStack();
            if (slot.isRecipe() || stack.func_190926_b()) continue;
            float xOffset = rand.nextFloat() * 0.8f + 0.1f;
            float yOffset = rand.nextFloat() * 0.8f + 0.1f;
            float zOffset = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)pos.func_177958_n() + xOffset), (double)((float)pos.func_177956_o() + yOffset), (double)((float)pos.func_177952_p() + zOffset), stack.func_77946_l());
            entityItem.field_70159_w = (float)rand.nextGaussian() * 0.05f;
            entityItem.field_70181_x = (float)rand.nextGaussian() * 0.05f + 0.2f;
            entityItem.field_70179_y = (float)rand.nextGaussian() * 0.05f;
            world.func_72838_d((Entity)entityItem);
        }
    }

    public int[] func_180463_a(EnumFacing facing) {
        if (!this.slotsForFace.containsKey(facing)) {
            this.slotsForFace.put(facing, this.inventory.values().stream().filter(slot -> slot.canInsert() || slot.canExtract()).mapToInt(BaseSlot::getIndex).toArray());
        }
        return this.slotsForFace.get(facing);
    }

    public boolean func_180462_a(int index, ItemStack itemstack, EnumFacing direction) {
        if (!this.func_94041_b(index, itemstack)) {
            return false;
        }
        InventorySlot slot = this.getSlot(index);
        return slot != null && slot.canInsert(direction);
    }

    public boolean func_180461_b(int index, ItemStack itemstack, EnumFacing direction) {
        InventorySlot slot = this.getSlot(index);
        return slot != null && slot.canExtract(direction);
    }

    @Override
    public String func_70005_c_() {
        return "";
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
    }

    @Override
    public void func_174888_l() {
        for (InventorySlot slot : this.inventory.values()) {
            slot.setContent(ItemStack.field_190927_a);
        }
        this.func_70296_d();
    }

    @Override
    public void func_174885_b(int id, int value) {
    }

    @Override
    public int func_174887_a_(int id) {
        return 0;
    }

    @Override
    public int func_174890_g() {
        return 0;
    }
}

