/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines;

import binnie.core.AbstractMod;
import binnie.core.Binnie;
import binnie.core.BinnieCore;
import binnie.core.machines.BlockMachine;
import binnie.core.machines.IMachineType;
import binnie.core.machines.ItemMachine;
import binnie.core.machines.MachinePackage;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;

public class MachineGroup {
    private final AbstractMod mod;
    private final String uid;
    private final Map<String, MachinePackage> packages = new LinkedHashMap<String, MachinePackage>();
    private final Map<Integer, MachinePackage> packagesID = new LinkedHashMap<Integer, MachinePackage>();
    private final BlockMachine block;

    public MachineGroup(AbstractMod mod, String uid, String blockName, IMachineType[] types) {
        this.mod = mod;
        this.uid = uid;
        this.createPackages(types);
        Binnie.MACHINE.registerMachineGroup(this);
        this.block = new BlockMachine(this, blockName);
        mod.getProxy().registerBlock(this.block);
        Item i = mod.getProxy().registerItem((Item)new ItemMachine(this.block));
        for (int j = 0; j < types.length; ++j) {
            BinnieCore.getBinnieProxy().registerModel(i, j, new ModelResourceLocation(i.getRegistryName(), "machine_type=" + j));
        }
    }

    private void createPackages(IMachineType[] types) {
        for (IMachineType type : types) {
            MachinePackage pack = type.getSupplier().get();
            if (pack == null) continue;
            pack.assignMetadata(type.ordinal());
            pack.setActive(true);
            this.addPackage(pack);
        }
    }

    private void addPackage(MachinePackage pack) {
        this.packages.put(pack.getUID(), pack);
        this.packagesID.put(pack.getMetadata(), pack);
        pack.setGroup(this);
    }

    public Collection<MachinePackage> getPackages() {
        return this.packages.values();
    }

    public BlockMachine getBlock() {
        return this.block;
    }

    @Nullable
    public MachinePackage getPackage(int metadata) {
        return this.packagesID.get(metadata);
    }

    public MachinePackage getPackage(String name) {
        return this.packages.get(name);
    }

    public String getUID() {
        return this.mod.getModId() + '.' + this.uid;
    }

    public String getShortUID() {
        return this.uid;
    }

    public void setCreativeTab(CreativeTabs tab) {
        this.block.func_149647_a(tab);
    }

    public AbstractMod getMod() {
        return this.mod;
    }
}

