/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.resource.stylesheet;

import binnie.core.gui.CraftGUI;
import binnie.core.gui.resource.stylesheet.StyleSheet;
import binnie.core.gui.resource.stylesheet.StyleSheetParser;
import binnie.core.gui.resource.textures.Texture;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class StyleSheetManager
implements IResourceManagerReloadListener {
    public static final String DEFAULT_SHEET = "default";
    public static final String PUNNETT_SHEET = "punnett";
    private static Map<String, StyleSheet> sheets;
    private static Map<String, ResourceLocation> sheetLocations;

    public StyleSheetManager() {
        sheets = new HashMap<String, StyleSheet>();
        sheetLocations = new HashMap<String, ResourceLocation>();
        CraftGUI.styleSheetManager = this;
        StyleSheetManager.registerLocation(DEFAULT_SHEET, new ResourceLocation("binniecore", "gui/stylesheet.json"));
        StyleSheetManager.registerLocation(PUNNETT_SHEET, new ResourceLocation("binniecore", "gui/punnett_stylesheet.json"));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_110549_a(IResourceManager manager) {
        sheets.clear();
        try {
            for (Map.Entry<String, ResourceLocation> entry : sheetLocations.entrySet()) {
                ResourceLocation location = entry.getValue();
                StyleSheet styleSheet = StyleSheetParser.parseSheet(manager, location);
                sheets.put(entry.getKey(), styleSheet);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load default stylesheet for Binnie's Mods.", e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static Texture getDefaultTexture(Object key) {
        StyleSheet styleSheet = StyleSheetManager.getDefaultSheet();
        return styleSheet.getTexture(key);
    }

    public static StyleSheet getDefaultSheet() {
        return StyleSheetManager.getSheet(DEFAULT_SHEET);
    }

    public static StyleSheet getSheet(String name) {
        return sheets.get(name);
    }

    public static void registerLocation(String name, ResourceLocation location) {
        sheetLocations.put(name, location);
    }
}

