/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.database;

import binnie.core.api.genetics.IBreedingSystem;
import binnie.core.api.gui.Alignment;
import binnie.core.api.gui.IWidget;
import binnie.core.api.gui.events.EventHandlerOrigin;
import binnie.core.gui.controls.ControlTextEdit;
import binnie.core.gui.controls.listbox.ControlListBox;
import binnie.core.gui.controls.listbox.ControlTextOption;
import binnie.core.gui.controls.page.ControlPage;
import binnie.core.gui.controls.page.ControlPages;
import binnie.core.gui.controls.tab.ControlTab;
import binnie.core.gui.controls.tab.ControlTabBar;
import binnie.core.gui.database.ControlBranchBox;
import binnie.core.gui.database.ControlSpeciesBox;
import binnie.core.gui.database.DatabaseTab;
import binnie.core.gui.database.IDatabaseMode;
import binnie.core.gui.database.ModeWidgets;
import binnie.core.gui.database.PageAbstract;
import binnie.core.gui.events.EventTextEdit;
import binnie.core.gui.events.EventValueChanged;
import binnie.core.gui.geometry.CraftGUIUtil;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.minecraft.MinecraftGUI;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.minecraft.control.ControlHelp;
import binnie.core.gui.window.Panel;
import binnie.core.util.I18N;
import com.mojang.authlib.GameProfile;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IClassification;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class WindowAbstractDatabase
extends Window {
    private final boolean master;
    private int selectionBoxWidth = 95;
    private final Map<IDatabaseMode, ModeWidgets> modes = new HashMap<IDatabaseMode, ModeWidgets>();
    private final IBreedingSystem system;
    @Nullable
    private Panel panelInformation = null;
    @Nullable
    private Panel panelSearch = null;
    @Nullable
    private ControlPages<IDatabaseMode> modePages = null;
    @Nullable
    private IAlleleSpecies gotoSpecies = null;

    public WindowAbstractDatabase(EntityPlayer player, Side side, boolean master, IBreedingSystem system, int wid) {
        super(100, 192, player, null, side);
        this.master = master;
        this.system = system;
        this.selectionBoxWidth = wid;
    }

    public void changeMode(IDatabaseMode mode) {
        this.modePages.setValue(mode);
    }

    public ControlPages<DatabaseTab> getInfoPages(IDatabaseMode mode) {
        ModeWidgets modeWidgets = this.modes.get(mode);
        return modeWidgets.getInfoPages();
    }

    @Nullable
    public ControlPages<IDatabaseMode> getModePages() {
        return this.modePages;
    }

    @Nullable
    public Panel getPanelSearch() {
        return this.panelSearch;
    }

    @Nullable
    public Panel getPanelInformation() {
        return this.panelInformation;
    }

    public boolean isMaster() {
        return this.master;
    }

    public IBreedingSystem getBreedingSystem() {
        return this.system;
    }

    protected ModeWidgets createMode(IDatabaseMode mode, ModeWidgets widgets) {
        this.modes.put(mode, widgets);
        return widgets;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initialiseClient() {
        this.setSize(new Point(176 + this.selectionBoxWidth + 22 + 8, 208));
        this.addEventHandler(EventValueChanged.class, event -> {
            ControlPage parent;
            Object value = event.getValue();
            IWidget eventOriginParent = event.getOrigin().getParent();
            if (eventOriginParent instanceof ControlPage && !(value instanceof DatabaseTab) && (parent = (ControlPage)eventOriginParent).getValue() instanceof IDatabaseMode) {
                for (IWidget child : parent.getChildren()) {
                    if (!(child instanceof ControlPages)) continue;
                    if (value == null) {
                        child.hide();
                        continue;
                    }
                    child.show();
                    for (IWidget widget : child.getChildren()) {
                        if (!(widget instanceof PageAbstract)) continue;
                        PageAbstract pageAbstract = (PageAbstract)widget;
                        pageAbstract.onValueChanged(value);
                    }
                }
            }
        });
        this.addEventHandler(EventTextEdit.class, EventHandlerOrigin.DIRECT_CHILD, this, event -> {
            for (ModeWidgets widgets : this.modes.values()) {
                widgets.getListBox().setValidator(object -> {
                    if (Objects.equals(event.getValue(), "")) {
                        return true;
                    }
                    ControlTextOption controlTextOption = (ControlTextOption)object;
                    return controlTextOption.getText().toLowerCase().contains(((String)event.getValue()).toLowerCase());
                });
            }
        });
        new ControlHelp(this, 4, 4);
        this.panelInformation = new Panel(this, 24, 24, 144, 176, MinecraftGUI.PanelType.BLACK);
        this.panelInformation.setColor(860416);
        this.panelSearch = new Panel(this, 176, 24, this.selectionBoxWidth, 160, MinecraftGUI.PanelType.BLACK);
        this.panelSearch.setColor(860416);
        this.modePages = new ControlPages(this, 0, 0, this.getSize().xPos(), this.getSize().yPos());
        new ControlTextEdit(this, 176, 184, this.selectionBoxWidth, 16);
        this.createMode(Mode.SPECIES, new ModeWidgets(Mode.SPECIES, this, (area, modePage) -> {
            GameProfile playerName = this.getUsername();
            Collection<IAlleleSpecies> speciesList = this.master ? this.system.getAllSpecies() : this.system.getDiscoveredSpecies(this.getWorld(), playerName);
            ControlSpeciesBox controlSpeciesBox = new ControlSpeciesBox(modePage, area.xPos(), area.yPos(), area.width(), area.height());
            controlSpeciesBox.setOptions(speciesList);
            return controlSpeciesBox;
        }));
        this.createMode(Mode.BRANCHES, new ModeWidgets(Mode.BRANCHES, this, (area, modePage) -> {
            EntityPlayer player = this.getPlayer();
            GameProfile playerName = player.func_146103_bH();
            List<IClassification> speciesList = this.master ? this.system.getAllBranches() : this.system.getDiscoveredBranches(this.getWorld(), playerName);
            ControlBranchBox controlBranchBox = new ControlBranchBox(modePage, area.xPos(), area.yPos(), area.width(), area.height());
            controlBranchBox.setOptions(speciesList);
            return controlBranchBox;
        }));
        this.createMode(Mode.BREEDER, new ModeWidgets(Mode.BREEDER, this, (area, modePage) -> new ControlListBox(modePage, area.xPos(), area.yPos(), area.width(), area.height(), 12)));
        this.addTabs();
        ControlTabBar<IDatabaseMode> tab = new ControlTabBar<IDatabaseMode>(this, 176 + this.selectionBoxWidth, 24, 22, 176, Alignment.RIGHT, this.modePages.getValues(), DatabaseControlTab::new);
        CraftGUIUtil.linkWidgets(tab, this.modePages);
        this.changeMode(Mode.SPECIES);
        for (IDatabaseMode mode : this.modes.keySet()) {
            ModeWidgets modeWidgets = this.modes.get(mode);
            modeWidgets.setInfoTabs(new ControlTabBar<Collection<DatabaseTab>>((IWidget)modeWidgets.getModePage(), 8, 24, 16, 176, Alignment.LEFT, modeWidgets.getInfoPages().getValues()));
            CraftGUIUtil.linkWidgets(modeWidgets.getInfoTabs(), modeWidgets.getInfoPages());
        }
    }

    @Override
    public void initialiseServer() {
        IBreedingTracker tracker = this.system.getSpeciesRoot().getBreedingTracker(this.getWorld(), this.getUsername());
        if (tracker != null) {
            tracker.synchToPlayer(this.getPlayer());
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void addTabs() {
    }

    public void gotoSpecies(IAlleleSpecies value) {
        if (value != null) {
            this.modePages.setValue(Mode.SPECIES);
            this.changeMode(Mode.SPECIES);
            this.modes.get(this.modePages.getValue()).getListBox().setValue(value);
        }
    }

    public void gotoSpeciesDelayed(IAlleleSpecies species) {
        this.gotoSpecies = species;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onUpdateClient() {
        super.onUpdateClient();
        if (this.gotoSpecies != null) {
            ((WindowAbstractDatabase)this.getTopParent()).gotoSpecies(this.gotoSpecies);
            this.gotoSpecies = null;
        }
    }

    private static class DatabaseControlTab
    extends ControlTab<IDatabaseMode> {
        public DatabaseControlTab(int x, int y, int w, int h, IDatabaseMode value) {
            super(x, y, w, h, value);
        }

        @Override
        public String getName() {
            return ((IDatabaseMode)this.value).getName();
        }
    }

    public static enum Mode implements IDatabaseMode
    {
        SPECIES,
        BRANCHES,
        BREEDER;


        @Override
        public String getName() {
            return I18N.localise("binniecore.gui.database.mode." + this.name().toLowerCase());
        }
    }
}

