/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.tile;

import binnie.botany.api.genetics.EnumFlowerColor;
import binnie.botany.api.genetics.IFlower;
import binnie.botany.api.genetics.IFlowerColor;
import binnie.botany.api.genetics.IFlowerType;
import binnie.botany.genetics.EnumFlowerType;
import binnie.botany.tile.TileEntityFlower;
import forestry.api.core.INbtWritable;
import net.minecraft.nbt.NBTTagCompound;

public class FlowerRenderInfo
implements INbtWritable {
    private final IFlowerColor primary;
    private final IFlowerColor secondary;
    private final IFlowerColor stem;
    private final IFlowerType type;
    private final byte age;
    private final boolean wilted;
    private final boolean flowered;
    private final byte section;

    public FlowerRenderInfo(IFlower flower, TileEntityFlower tile) {
        this.section = (byte)tile.getSection();
        this.primary = flower.getGenome().getPrimaryColor();
        this.secondary = flower.getGenome().getSecondaryColor();
        this.stem = flower.getGenome().getStemColor();
        this.age = (byte)flower.getAge();
        this.wilted = flower.isWilted();
        this.flowered = flower.hasFlowered();
        this.type = flower.getGenome().getType();
    }

    public FlowerRenderInfo(NBTTagCompound nbt) {
        this.primary = EnumFlowerColor.values()[nbt.func_74771_c("primary")].getFlowerColorAllele();
        this.secondary = EnumFlowerColor.values()[nbt.func_74771_c("secondary")].getFlowerColorAllele();
        this.stem = EnumFlowerColor.values()[nbt.func_74771_c("stem")].getFlowerColorAllele();
        this.type = EnumFlowerType.values()[nbt.func_74771_c("type")];
        this.age = nbt.func_74771_c("age");
        this.section = nbt.func_74771_c("section");
        this.wilted = nbt.func_74767_n("wilted");
        this.flowered = nbt.func_74767_n("flowered");
    }

    public boolean equals(Object obj) {
        if (obj instanceof FlowerRenderInfo) {
            FlowerRenderInfo o = (FlowerRenderInfo)obj;
            return o.age == this.age && o.wilted == this.wilted && o.flowered == this.flowered && o.primary == this.primary && o.secondary == this.secondary && o.stem == this.stem && o.type == this.type;
        }
        return super.equals(obj);
    }

    public IFlowerColor getPrimary() {
        return this.primary;
    }

    public IFlowerColor getSecondary() {
        return this.secondary;
    }

    public IFlowerColor getStem() {
        return this.stem;
    }

    public IFlowerType getType() {
        return this.type;
    }

    public byte getAge() {
        return this.age;
    }

    public boolean isWilted() {
        return this.wilted;
    }

    public boolean isFlowered() {
        return this.flowered;
    }

    public byte getSection() {
        return this.section;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74774_a("primary", (byte)this.primary.getID());
        nbt.func_74774_a("secondary", (byte)this.secondary.getID());
        nbt.func_74774_a("stem", (byte)this.stem.getID());
        nbt.func_74774_a("type", (byte)this.type.ordinal());
        nbt.func_74774_a("age", this.age);
        nbt.func_74774_a("section", this.section);
        nbt.func_74757_a("wilted", this.wilted);
        nbt.func_74757_a("flowered", this.flowered);
        return nbt;
    }
}

