/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocators.item;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.JItemMultiPart;
import codechicken.multipart.TMultiPart;
import codechicken.translocators.client.render.RenderTranslocatorPartItem;
import codechicken.translocators.part.FluidTranslocatorPart;
import codechicken.translocators.part.ItemTranslocatorPart;
import codechicken.translocators.part.TranslocatorPart;
import net.minecraft.block.SoundType;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class TranslocatorPartItem
extends JItemMultiPart {
    public static final SoundType placement_sound = new SoundType(1.0f, 1.0f, null, null, SoundEvents.field_187902_gb, null, null);

    public TranslocatorPartItem() {
        this.func_77627_a(true);
        this.func_77655_b("translocators.part");
        this.func_77637_a(CreativeTabs.field_78028_d);
        this.setRegistryName("translocator_part");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TMultiPart newPart(ItemStack item, EntityPlayer player, World world, BlockPos pos, int side, Vector3 vhit) {
        TranslocatorPart part;
        BlockPos onPos = pos.func_177972_a(EnumFacing.field_82609_l[side ^ 1]);
        TileEntity tile = world.func_175625_s(onPos);
        if (tile == null) return null;
        if (item.func_77960_j() == 0) {
            if (!tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.field_82609_l[side])) return null;
            part = new ItemTranslocatorPart();
            return part.setupPlacement(player, side);
        } else {
            if (!tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.field_82609_l[side])) return null;
            part = new FluidTranslocatorPart();
        }
        return part.setupPlacement(player, side);
    }

    public SoundType getPlacementSound(ItemStack item) {
        return placement_sound;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this, 1, 0));
            items.add((Object)new ItemStack((Item)this, 1, 1));
        }
    }

    public String func_77667_c(ItemStack stack) {
        String name = "unknown";
        if (stack.func_77960_j() == 0) {
            name = "item";
        } else if (stack.func_77960_j() == 1) {
            name = "fluid";
        }
        return super.func_77667_c(stack) + "_" + name;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModels() {
        ModelResourceLocation loc = new ModelResourceLocation(this.getRegistryName(), "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)loc);
        ModelLoader.setCustomMeshDefinition((Item)this, s -> loc);
        ModelRegistryHelper.register((ModelResourceLocation)loc, (IBakedModel)new RenderTranslocatorPartItem());
    }
}

