/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;

public class ByteUtils {
    public static int on(int val, int bit) {
        return val | 1 << bit;
    }

    public static int off(int val, int bit) {
        return val & ~(1 << bit);
    }

    public static int set(int val, int bit, boolean flag) {
        return flag ? val | 1 << bit : val & ~(1 << bit);
    }

    public static long set(long val, int bit, boolean flag) {
        return flag ? val | (long)(1 << bit) : val & (long)(~(1 << bit));
    }

    public static boolean get(int val, int slot) {
        return (val & 1 << slot) != 0;
    }

    public static boolean get(long val, int slot) {
        return (val & (long)(1 << slot)) != 0L;
    }

    public static void writeVLI(DataOutput output, int value) {
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (Object)"Value cannot be negative");
        try {
            int b;
            while (true) {
                b = value & 0x7F;
                int next = value >> 7;
                if (next <= 0) break;
                output.writeByte(b |= 0x80);
                value = next;
            }
            output.writeByte(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int readVLI(DataInput input) {
        int result = 0;
        int shift = 0;
        try {
            byte b;
            do {
                b = input.readByte();
                result |= (b & 0x7F) << shift;
                shift += 7;
            } while (b < 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static int nextPowerOf2(int v) {
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        return ++v;
    }

    public static boolean isPowerOfTwo(int size) {
        return (size & size - 1) == 0;
    }

    public static int enumSetToBits(Set<? extends Enum<?>> dirs) {
        int value = 0;
        for (Enum<?> e : dirs) {
            int bit = e.ordinal();
            Preconditions.checkArgument((bit < 32 ? 1 : 0) != 0, (String)"Enum %s has too many values", e.getClass());
            value = ByteUtils.on(value, bit);
        }
        return value;
    }

    public static abstract class CountingBitIterator<T>
    extends UnmodifiableIterator<T> {
        private int value;
        private int count;

        public CountingBitIterator(int value) {
            this.value = value;
        }

        protected abstract T convert(int var1);

        public boolean hasNext() {
            return this.value != 0;
        }

        public T next() {
            while (this.value != 0) {
                boolean result = (this.value & 1) != 0;
                this.value >>= 1;
                if (result) {
                    return this.convert(this.count++);
                }
                ++this.count;
            }
            throw new IllegalStateException();
        }
    }

    public static abstract class BitIterator
    extends UnmodifiableIterator<Boolean> {
        private int value;

        public BitIterator(int value) {
            this.value = value;
        }

        public boolean hasNext() {
            return this.value != 0;
        }

        public Boolean next() {
            boolean result = (this.value & 1) != 0;
            this.value >>= 1;
            return result;
        }
    }
}

