/*
 * Decompiled with CFR 0.152.
 */
package openmods.serializable.providers;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.lang.reflect.Type;
import net.minecraft.network.PacketBuffer;
import openmods.serializable.SerializerRegistry;
import openmods.utils.bitstream.InputBitStream;
import openmods.utils.bitstream.OutputBitStream;
import openmods.utils.io.IStreamSerializer;
import openmods.utils.io.StreamAdapters;
import openmods.utils.io.StreamUtils;

public abstract class NullableCollectionSerializer<T>
implements IStreamSerializer<T> {
    private final IStreamSerializer<Object> componentSerializer;
    private final TypeToken<?> componentType;

    public static IStreamSerializer<Object[]> createObjectArraySerializer(TypeToken<?> componentType) {
        return new NullableCollectionSerializer<Object[]>(componentType){

            @Override
            protected Object[] createCollection(TypeToken<?> componentCls, int length) {
                return new Object[length];
            }

            @Override
            protected int getLength(Object[] collection) {
                return collection.length;
            }

            @Override
            protected Object getElement(Object[] collection, int index) {
                return collection[index];
            }

            @Override
            protected void setElement(Object[] collection, int index, Object value) {
                collection[index] = value;
            }
        };
    }

    public NullableCollectionSerializer(TypeToken<?> componentType) {
        Type type = componentType.getType();
        this.componentSerializer = SerializerRegistry.instance.findSerializer(type);
        Preconditions.checkNotNull(this.componentSerializer, (String)"Can't find serializer for %s", (Object)type);
        this.componentType = componentType;
    }

    @Override
    public T readFromStream(PacketBuffer input) throws IOException {
        int length = input.func_150792_a();
        T result = this.createCollection(this.componentType, length);
        if (length > 0) {
            int nullBitsSize = StreamUtils.bitsToBytes(length);
            byte[] nullBits = StreamUtils.readBytes(input, nullBitsSize);
            InputBitStream nullBitStream = new InputBitStream(StreamAdapters.createSource(nullBits));
            for (int i = 0; i < length; ++i) {
                if (!nullBitStream.readBit()) continue;
                Object value = this.componentSerializer.readFromStream(input);
                this.setElement(result, i, value);
            }
        }
        return result;
    }

    @Override
    public void writeToStream(T o, PacketBuffer output) throws IOException {
        int length = this.getLength(o);
        output.func_150787_b(length);
        if (length > 0) {
            Object value;
            int i;
            OutputBitStream nullBitsStream = new OutputBitStream(StreamAdapters.createSink((ByteBuf)output));
            for (i = 0; i < length; ++i) {
                value = this.getElement(o, i);
                nullBitsStream.writeBit(value != null);
            }
            nullBitsStream.flush();
            for (i = 0; i < length; ++i) {
                value = this.getElement(o, i);
                if (value == null) continue;
                this.componentSerializer.writeToStream(value, output);
            }
        }
    }

    protected abstract T createCollection(TypeToken<?> var1, int var2);

    protected abstract int getLength(T var1);

    protected abstract Object getElement(T var1, int var2);

    protected abstract void setElement(T var1, int var2, Object var3);
}

