/*
 * Decompiled with CFR 0.152.
 */
package openmods.renderer;

import com.google.common.base.Preconditions;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import openmods.Log;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class CachedRendererFactory {
    public CachedRenderer createRenderer(Tessellator tes) {
        if (OpenGlHelper.func_176075_f()) {
            return new VboRenderer(tes);
        }
        return new DisplayListRenderer(tes);
    }

    private static class DisplayListRenderer
    implements CachedRenderer {
        private int displayList = GL11.glGenLists((int)1);

        private boolean isDisplayListValid() {
            return this.displayList != 0;
        }

        public DisplayListRenderer(Tessellator tes) {
            if (this.isDisplayListValid()) {
                GL11.glNewList((int)this.displayList, (int)4864);
                tes.func_78381_a();
                GL11.glEndList();
            }
        }

        @Override
        public void render() {
            if (this.isDisplayListValid()) {
                GL11.glCallList((int)this.displayList);
            }
        }

        @Override
        public void dispose() {
            if (this.isDisplayListValid()) {
                GL11.glDeleteLists((int)this.displayList, (int)1);
            }
        }
    }

    private static class VboRenderer
    implements CachedRenderer {
        private final VertexBuffer vb;
        private final int drawMode;
        private final Runnable setup;
        private final Runnable cleanup;

        public VboRenderer(Tessellator tes) {
            BufferBuilder buffer = tes.func_178180_c();
            VertexFormat vf = buffer.func_178973_g();
            this.vb = new VertexBuffer(vf);
            this.drawMode = buffer.func_178979_i();
            buffer.func_178977_d();
            buffer.func_178965_a();
            this.vb.func_181722_a(buffer.func_178966_f());
            Runnable setup = () -> {};
            Runnable cleanup = () -> {};
            int stride = vf.func_177338_f();
            block8: for (int i = vf.func_177345_h() - 1; i >= 0; --i) {
                VertexFormatElement attr = vf.func_177348_c(i);
                int offset = vf.func_181720_d(i);
                int count = attr.func_177370_d();
                int constant = attr.func_177367_b().func_177397_c();
                int index = attr.func_177369_e();
                VertexFormatElement.EnumUsage usage = attr.func_177375_c();
                Runnable prevSetup = setup;
                Runnable prevCleanup = cleanup;
                switch (usage) {
                    case POSITION: {
                        setup = () -> {
                            GL11.glVertexPointer((int)count, (int)constant, (int)stride, (long)offset);
                            GL11.glEnableClientState((int)32884);
                            prevSetup.run();
                        };
                        cleanup = () -> {
                            GL11.glDisableClientState((int)32884);
                            prevCleanup.run();
                        };
                        continue block8;
                    }
                    case NORMAL: {
                        Preconditions.checkArgument((count == 3 ? 1 : 0) != 0, (String)"Normal attribute %s should have the size 3", (Object)attr);
                        setup = () -> {
                            GL11.glNormalPointer((int)constant, (int)stride, (long)offset);
                            GL11.glEnableClientState((int)32885);
                            prevSetup.run();
                        };
                        cleanup = () -> {
                            GL11.glDisableClientState((int)32885);
                            prevCleanup.run();
                        };
                        continue block8;
                    }
                    case COLOR: {
                        setup = () -> {
                            GL11.glColorPointer((int)count, (int)constant, (int)stride, (long)offset);
                            GL11.glEnableClientState((int)32886);
                            prevSetup.run();
                        };
                        cleanup = () -> {
                            GL11.glDisableClientState((int)32886);
                            GlStateManager.func_179117_G();
                            prevCleanup.run();
                        };
                        continue block8;
                    }
                    case UV: {
                        setup = () -> {
                            OpenGlHelper.func_77472_b((int)(OpenGlHelper.field_77478_a + index));
                            GL11.glTexCoordPointer((int)count, (int)constant, (int)stride, (long)offset);
                            GL11.glEnableClientState((int)32888);
                            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
                            prevSetup.run();
                        };
                        cleanup = () -> {
                            OpenGlHelper.func_77472_b((int)(OpenGlHelper.field_77478_a + index));
                            GL11.glDisableClientState((int)32888);
                            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
                            prevCleanup.run();
                        };
                        continue block8;
                    }
                    case PADDING: {
                        continue block8;
                    }
                    case GENERIC: {
                        setup = () -> {
                            GL20.glEnableVertexAttribArray((int)index);
                            GL20.glVertexAttribPointer((int)index, (int)count, (int)constant, (boolean)false, (int)stride, (long)offset);
                            prevSetup.run();
                        };
                        cleanup = () -> {
                            GL20.glDisableVertexAttribArray((int)index);
                            prevCleanup.run();
                        };
                    }
                    default: {
                        Log.severe("Unimplemented vanilla attribute upload: %s", usage.func_177384_a());
                    }
                }
            }
            this.setup = setup;
            this.cleanup = cleanup;
        }

        @Override
        public void render() {
            this.vb.func_177359_a();
            this.setup.run();
            this.vb.func_177358_a(this.drawMode);
            this.cleanup.run();
            this.vb.func_177361_b();
        }

        @Override
        public void dispose() {
            this.vb.func_177362_c();
        }
    }

    public static interface CachedRenderer {
        public void render();

        public void dispose();
    }
}

