/*
 * Decompiled with CFR 0.152.
 */
package openmods.geometry;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import net.minecraft.util.EnumFacing;
import openmods.geometry.HalfAxis;

public class LocalDirections {
    public final EnumFacing front;
    public final EnumFacing back;
    public final EnumFacing top;
    public final EnumFacing bottom;
    public final EnumFacing left;
    public final EnumFacing right;
    private static final Table<EnumFacing, EnumFacing, LocalDirections> frontAndTop = HashBasedTable.create();

    private LocalDirections(EnumFacing front, EnumFacing top) {
        this.front = front;
        this.back = front.func_176734_d();
        this.top = top;
        this.bottom = top.func_176734_d();
        HalfAxis frontHa = HalfAxis.fromEnumFacing(front);
        HalfAxis topHa = HalfAxis.fromEnumFacing(top);
        this.right = frontHa.cross((HalfAxis)topHa).dir;
        this.left = topHa.cross((HalfAxis)frontHa).dir;
    }

    public static LocalDirections fromFrontAndTop(EnumFacing front, EnumFacing top) {
        return (LocalDirections)frontAndTop.get((Object)front, (Object)top);
    }

    static {
        for (EnumFacing front : EnumFacing.field_82609_l) {
            for (EnumFacing top : EnumFacing.field_82609_l) {
                if (top.func_176740_k() == front.func_176740_k()) continue;
                frontAndTop.put((Object)front, (Object)top, (Object)new LocalDirections(front, top));
            }
        }
    }
}

