/*
 * Decompiled with CFR 0.152.
 */
package k4unl.minecraft.k4lib.network.messages;

import io.netty.buffer.ByteBuf;
import k4unl.minecraft.k4lib.network.messages.AbstractPacket;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class LocationDoublePacket<REQ extends IMessage>
extends AbstractPacket<REQ> {
    protected double x;
    protected double y;
    protected double z;

    public LocationDoublePacket() {
    }

    public LocationDoublePacket(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
    }

    public NetworkRegistry.TargetPoint getTargetPoint(World world) {
        return this.getTargetPoint(world, 64.0);
    }

    public NetworkRegistry.TargetPoint getTargetPoint(World world, double updateDistance) {
        return new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), this.x, this.y, this.z, updateDistance);
    }
}

