/*
 * Decompiled with CFR 0.152.
 */
package k4unl.minecraft.k4lib.lib;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Location {
    private int x;
    private int y;
    private int z;
    private int dimension;

    public Location(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Location(String x, String y, String z) {
        this.x = Integer.parseInt(x);
        this.y = Integer.parseInt(y);
        this.z = Integer.parseInt(z);
    }

    public Location(EntityPlayer player) {
        this.x = (int)player.field_70165_t;
        this.y = (int)player.field_70163_u;
        this.z = (int)player.field_70161_v;
    }

    public Location(Location clone) {
        this.x = clone.x;
        this.y = clone.y;
        this.z = clone.z;
    }

    public Location(int xCoord, int yCoord, int zCoord, EnumFacing dir) {
        this.x = xCoord + dir.func_82601_c();
        this.y = yCoord + dir.func_96559_d();
        this.z = zCoord + dir.func_96559_d();
    }

    public Location(int _x, int _y, int _z, int _dimension) {
        this.x = _x;
        this.y = _y;
        this.z = _z;
        this.dimension = _dimension;
    }

    public Location(int[] loc) {
        if (loc.length > 2) {
            this.x = loc[0];
            this.y = loc[1];
            this.z = loc[2];
            if (loc.length > 3) {
                this.dimension = loc[3];
            }
        }
    }

    public Location(int _x, int _y, int _z, EnumFacing d, int offset) {
        this.x = _x + d.func_82601_c() * offset;
        this.y = _y + d.func_96559_d() * offset;
        this.z = _z + d.func_82599_e() * offset;
    }

    public Location(int _x, int _y, int _z, int _dimension, EnumFacing d, int offset) {
        this.x = _x + d.func_82601_c() * offset;
        this.y = _y + d.func_96559_d() * offset;
        this.z = _z + d.func_82599_e() * offset;
        this.dimension = _dimension;
    }

    public Location(Location baseLoc, EnumFacing d, int offset) {
        this.x = baseLoc.getX() + d.func_82601_c() * offset;
        this.y = baseLoc.getY() + d.func_96559_d() * offset;
        this.z = baseLoc.getZ() + d.func_82599_e() * offset;
        this.dimension = baseLoc.dimension;
    }

    public Location(int _x, int _y, int _z, int _dimension, EnumFacing d) {
        this.x = _x + d.func_82601_c();
        this.y = _y + d.func_96559_d();
        this.z = _z + d.func_82599_e();
        this.dimension = _dimension;
    }

    public Location(BlockPos pos) {
        if (pos != null) {
            this.x = pos.func_177958_n();
            this.y = pos.func_177956_o();
            this.z = pos.func_177952_p();
        }
    }

    public Location(BlockPos pos, int dimension) {
        if (pos != null) {
            this.x = pos.func_177958_n();
            this.y = pos.func_177956_o();
            this.z = pos.func_177952_p();
            this.dimension = dimension;
        }
    }

    public Location(BlockPos pos, EnumFacing offset) {
        this(pos, offset, 1);
    }

    public Location(RayTraceResult blockLookedAt) {
        if (blockLookedAt != null) {
            this.x = blockLookedAt.func_178782_a().func_177958_n();
            this.y = blockLookedAt.func_178782_a().func_177956_o();
            this.z = blockLookedAt.func_178782_a().func_177952_p();
        }
    }

    public Location(BlockPos pos, EnumFacing baseDir, int offset) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), baseDir, offset);
    }

    public boolean equals(Location toTest) {
        return this.x == toTest.x && this.y == toTest.y && this.z == toTest.z;
    }

    public void setLocation(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void setLocation(int[] coords) {
        this.x = coords[0];
        this.y = coords[1];
        this.z = coords[2];
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public void setX(int newX) {
        this.x = newX;
    }

    public void setY(int newY) {
        this.y = newY;
    }

    public void setZ(int newZ) {
        this.z = newZ;
    }

    public int[] getLocation() {
        int[] ret = new int[]{this.x, this.y, this.z};
        return ret;
    }

    public Location getNewOffset(EnumFacing dir, int offset) {
        return new Location(this, dir, offset);
    }

    public int getDifference(Location otherLoc) {
        return (int)Math.sqrt(Math.pow(this.x - otherLoc.x, 2.0) + Math.pow(this.y - otherLoc.y, 2.0) + Math.pow(this.z - otherLoc.z, 2.0));
    }

    public int getDifference(BlockPos otherLoc) {
        return (int)Math.sqrt(Math.pow(this.x - otherLoc.func_177958_n(), 2.0) + Math.pow(this.y - otherLoc.func_177956_o(), 2.0) + Math.pow(this.z - otherLoc.func_177952_p(), 2.0));
    }

    public String printLocation() {
        return "X: " + this.x + " Y: " + this.y + " Z: " + this.z;
    }

    public String printCoords() {
        return this.x + ", " + this.y + ", " + this.z;
    }

    public boolean compare(int x, int y, int z) {
        return this.x == x && this.y == y && this.z == z;
    }

    public void addX(int toAdd) {
        this.x += toAdd;
    }

    public void addY(int toAdd) {
        this.y += toAdd;
    }

    public void addZ(int toAdd) {
        this.z += toAdd;
    }

    public void offset(EnumFacing dir, int offsetInt) {
        this.x += dir.func_82601_c() * offsetInt;
        this.y += dir.func_96559_d() * offsetInt;
        this.z += dir.func_82599_e() * offsetInt;
    }

    public int[] getIntArray() {
        return new int[]{this.x, this.y, this.z, this.dimension};
    }

    public Block getBlock(IBlockAccess iba) {
        return iba.func_180495_p(new BlockPos(this.x, this.y, this.z)).func_177230_c();
    }

    public Block getBlock(IBlockAccess iba, EnumFacing dir) {
        return iba.func_180495_p(new BlockPos(this.x + dir.func_82601_c(), this.y + dir.func_96559_d(), this.z + dir.func_82599_e())).func_177230_c();
    }

    public TileEntity getTE(IBlockAccess iba) {
        return iba.func_175625_s(new BlockPos(this.x, this.y, this.z));
    }

    public TileEntity getTE(IBlockAccess iba, EnumFacing dir) {
        return iba.func_175625_s(new BlockPos(this.x + dir.func_82601_c(), this.y + dir.func_96559_d(), this.z + dir.func_82599_e()));
    }

    public String print() {
        return String.format("D: " + this.dimension + " X: " + this.x + " Y: " + this.y + " Z: " + this.z, new Object[0]);
    }

    public int getDimension() {
        return this.dimension;
    }

    public boolean isInList(List<Location> locationList) {
        for (Location loc : locationList) {
            if (!loc.equals(this)) continue;
            return true;
        }
        return false;
    }

    public BlockPos toBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public boolean compare(BlockPos pos) {
        return this.compare(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public IBlockState getBlockState(World worldObj) {
        return worldObj.func_180495_p(this.toBlockPos());
    }
}

