/*
 * Decompiled with CFR 0.152.
 */
package k4unl.minecraft.k4lib.lib;

import k4unl.minecraft.k4lib.lib.Location;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class Area {
    private String name;
    private Location loc1;
    private Location loc2;
    private int dimensionId;

    public Area(String name_, Location loc1_, Location loc2_, int dimensionId_) {
        this.name = name_;
        this.loc1 = loc1_;
        this.loc2 = loc2_;
        this.dimensionId = dimensionId_;
    }

    public Area(String name_) {
        this(name_, null, null, 0);
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void setLoc1(Location newLoc) {
        this.loc1 = newLoc;
    }

    public void setLoc2(Location newLoc) {
        this.loc2 = newLoc;
    }

    public void setDimensionId(int newId) {
        this.dimensionId = newId;
    }

    public Location getLoc1() {
        return this.loc1;
    }

    public Location getLoc2() {
        return this.loc2;
    }

    public String getName() {
        return this.name;
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public boolean contains(Location locToCheck) {
        return this.contains(locToCheck.getX(), locToCheck.getY(), locToCheck.getZ());
    }

    public boolean contains(int x, int y, int z) {
        int x1 = Math.min(this.loc1.getX(), this.loc2.getX());
        int y1 = Math.min(this.loc1.getY(), this.loc2.getY());
        int z1 = Math.min(this.loc1.getZ(), this.loc2.getZ());
        int x2 = Math.max(this.loc1.getX(), this.loc2.getX());
        int y2 = Math.max(this.loc1.getY(), this.loc2.getY());
        int z2 = Math.max(this.loc1.getZ(), this.loc2.getZ());
        return x >= x1 && x <= x2 && y >= y1 && y <= y2 && z >= z1 && z <= z2;
    }

    public boolean contains(BlockPos pos) {
        return this.contains(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public int getMinX() {
        return Math.min(this.loc1.getX(), this.loc2.getX());
    }

    public int getMinY() {
        return Math.min(this.loc1.getY(), this.loc2.getY());
    }

    public int getMinZ() {
        return Math.min(this.loc1.getZ(), this.loc2.getZ());
    }

    public int getMaxX() {
        return Math.max(this.loc1.getX(), this.loc2.getX());
    }

    public int getMaxY() {
        return Math.max(this.loc1.getY(), this.loc2.getY());
    }

    public int getMaxZ() {
        return Math.max(this.loc1.getZ(), this.loc2.getZ());
    }

    public AxisAlignedBB getAABB() {
        return new AxisAlignedBB((double)this.getMinX(), (double)this.getMinY(), (double)this.getMinZ(), (double)this.getMaxX(), (double)this.getMaxY(), (double)this.getMaxZ());
    }
}

