/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.server.component;

import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import li.cil.oc.OpenComputers$;
import li.cil.oc.Settings$;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.DeviceInfo;
import li.cil.oc.api.fs.Label;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import li.cil.oc.server.PacketSender$;
import li.cil.oc.server.component.package$;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.DimensionManager;
import scala.Array$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.convert.WrapAsJava$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t=g\u0001B\u0001\u0003\u00015\u0011Q\u0001\u0012:jm\u0016T!a\u0001\u0003\u0002\u0013\r|W\u000e]8oK:$(BA\u0003\u0007\u0003\u0019\u0019XM\u001d<fe*\u0011q\u0001C\u0001\u0003_\u000eT!!\u0003\u0006\u0002\u0007\rLGNC\u0001\f\u0003\ta\u0017n\u0001\u0001\u0014\u0007\u0001qa\u0003\u0005\u0002\u0010)5\t\u0001C\u0003\u0002\u0012%\u00051\u0001O]3gC\nT!a\u0005\u0004\u0002\u0007\u0005\u0004\u0018.\u0003\u0002\u0016!\tQ\u0012IY:ue\u0006\u001cG/T1oC\u001e,G-\u00128wSJ|g.\\3oiB\u0011qCG\u0007\u00021)\u0011\u0011DE\u0001\u0007IJLg/\u001a:\n\u0005mA\"A\u0003#fm&\u001cW-\u00138g_\"AQ\u0004\u0001BC\u0002\u0013\u0005a$\u0001\u0005dCB\f7-\u001b;z+\u0005y\u0002C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#aA%oi\"Aa\u0005\u0001B\u0001B\u0003%q$A\u0005dCB\f7-\u001b;zA!A\u0001\u0006\u0001BC\u0002\u0013\u0005a$\u0001\u0007qY\u0006$H/\u001a:D_VtG\u000f\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003 \u00035\u0001H.\u0019;uKJ\u001cu.\u001e8uA!AA\u0006\u0001BC\u0002\u0013\u0005Q&A\u0003mC\n,G.F\u0001/!\ty#'D\u00011\u0015\t\t$#\u0001\u0002gg&\u00111\u0007\r\u0002\u0006\u0019\u0006\u0014W\r\u001c\u0005\tk\u0001\u0011\t\u0011)A\u0005]\u00051A.\u00192fY\u0002B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001O\u0001\u0005Q>\u001cH\u000fE\u0002!smJ!AO\u0011\u0003\r=\u0003H/[8o!\tat(D\u0001>\u0015\tq$#A\u0004oKR<xN]6\n\u0005\u0001k$aD#om&\u0014xN\\7f]RDun\u001d;\t\u0011\t\u0003!Q1A\u0005\u0002\r\u000bQa]8v]\u0012,\u0012\u0001\u0012\t\u0004Ae*\u0005C\u0001$J\u001d\t\u0001s)\u0003\u0002IC\u00051\u0001K]3eK\u001aL!AS&\u0003\rM#(/\u001b8h\u0015\tA\u0015\u0005\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003E\u0003\u0019\u0019x.\u001e8eA!Aq\n\u0001BC\u0002\u0013\u0005a$A\u0003ta\u0016,G\r\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003 \u0003\u0019\u0019\b/Z3eA!A1\u000b\u0001BC\u0002\u0013\u0005A+\u0001\u0005jg2{7m[3e+\u0005)\u0006C\u0001\u0011W\u0013\t9\u0016EA\u0004C_>dW-\u00198\t\u0011e\u0003!\u0011!Q\u0001\nU\u000b\u0011\"[:M_\u000e\\W\r\u001a\u0011\t\u000bm\u0003A\u0011\u0001/\u0002\rqJg.\u001b;?)!iv\fY1cG\u0012,\u0007C\u00010\u0001\u001b\u0005\u0011\u0001\"B\u000f[\u0001\u0004y\u0002\"\u0002\u0015[\u0001\u0004y\u0002\"\u0002\u0017[\u0001\u0004q\u0003\"B\u001c[\u0001\u0004A\u0004\"\u0002\"[\u0001\u0004!\u0005\"B([\u0001\u0004y\u0002\"B*[\u0001\u0004)\u0006bB4\u0001\u0005\u0004%\t\u0005[\u0001\u0005]>$W-F\u0001j!\ta$.\u0003\u0002l{\t\u00112i\\7q_:,g\u000e^\"p]:,7\r^8s\u0011\u0019i\u0007\u0001)A\u0005S\u0006)an\u001c3fA!)q\u000e\u0001C\u0005a\u0006A1/\u0019<f!\u0006$\b.F\u0001r!\t\u0011x/D\u0001t\u0015\t!X/\u0001\u0002j_*\ta/\u0001\u0003kCZ\f\u0017B\u0001=t\u0005\u00111\u0015\u000e\\3\t\u000fi\u0004!\u0019!C\u0007w\u0006Q1/Z2u_J\u001c\u0016N_3\u0016\u0003q|\u0011!`\u000f\u0003\u0005\u0001Aaa \u0001!\u0002\u001ba\u0018aC:fGR|'oU5{K\u0002B\u0011\"a\u0001\u0001\u0005\u0004%I!!\u0002\u0002\t\u0011\fG/Y\u000b\u0003\u0003\u000f\u0001R\u0001IA\u0005\u0003\u001bI1!a\u0003\"\u0005\u0015\t%O]1z!\r\u0001\u0013qB\u0005\u0004\u0003#\t#\u0001\u0002\"zi\u0016D\u0001\"!\u0006\u0001A\u0003%\u0011qA\u0001\u0006I\u0006$\u0018\r\t\u0005\t\u00033\u0001!\u0019!C\u0005=\u0005Y1/Z2u_J\u001cu.\u001e8u\u0011\u001d\ti\u0002\u0001Q\u0001\n}\tAb]3di>\u00148i\\;oi\u0002B\u0001\"!\t\u0001\u0005\u0004%IAH\u0001\u0012g\u0016\u001cGo\u001c:t!\u0016\u0014\b\u000b\\1ui\u0016\u0014\bbBA\u0013\u0001\u0001\u0006IaH\u0001\u0013g\u0016\u001cGo\u001c:t!\u0016\u0014\b\u000b\\1ui\u0016\u0014\b\u0005\u0003\u0005\u0002*\u0001\u0001\r\u0011\"\u0003\u001f\u0003\u001dAW-\u00193Q_ND\u0011\"!\f\u0001\u0001\u0004%I!a\f\u0002\u0017!,\u0017\r\u001a)pg~#S-\u001d\u000b\u0005\u0003c\t9\u0004E\u0002!\u0003gI1!!\u000e\"\u0005\u0011)f.\u001b;\t\u0013\u0005e\u00121FA\u0001\u0002\u0004y\u0012a\u0001=%c!9\u0011Q\b\u0001!B\u0013y\u0012\u0001\u00035fC\u0012\u0004vn\u001d\u0011\t\u0013\u0005\u0005\u0003A1A\u0005\u0006\u0005\r\u0013a\u0004:fC\u0012\u001cVm\u0019;pe\u000e{7\u000f^:\u0016\u0005\u0005\u0015\u0003#\u0002\u0011\u0002\n\u0005\u001d\u0003c\u0001\u0011\u0002J%\u0019\u00111J\u0011\u0003\r\u0011{WO\u00197f\u0011!\ty\u0005\u0001Q\u0001\u000e\u0005\u0015\u0013\u0001\u0005:fC\u0012\u001cVm\u0019;pe\u000e{7\u000f^:!\u0011%\t\u0019\u0006\u0001b\u0001\n\u000b\t\u0019%\u0001\txe&$XmU3di>\u00148i\\:ug\"A\u0011q\u000b\u0001!\u0002\u001b\t)%A\txe&$XmU3di>\u00148i\\:ug\u0002B\u0011\"a\u0017\u0001\u0005\u0004%)!a\u0011\u0002\u001bI,\u0017\r\u001a\"zi\u0016\u001cun\u001d;t\u0011!\ty\u0006\u0001Q\u0001\u000e\u0005\u0015\u0013A\u0004:fC\u0012\u0014\u0015\u0010^3D_N$8\u000f\t\u0005\n\u0003G\u0002!\u0019!C\u0003\u0003\u0007\nab\u001e:ji\u0016\u0014\u0015\u0010^3D_N$8\u000f\u0003\u0005\u0002h\u0001\u0001\u000bQBA#\u0003=9(/\u001b;f\u0005f$XmQ8tiN\u0004\u0003BCA6\u0001!\u0015\r\u0011\"\u0004\u0002n\u0005QA-\u001a<jG\u0016LeNZ8\u0016\u0005\u0005=\u0004\u0003CA9\u0003w\ny(a \u000e\u0005\u0005M$\u0002BA;\u0003o\n\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005e\u0014%\u0001\u0006d_2dWm\u0019;j_:LA!! \u0002t\t\u0019Q*\u00199\u0011\t\u0005\u0005\u0015qQ\u0007\u0003\u0003\u0007S1!!\"v\u0003\u0011a\u0017M\\4\n\u0007)\u000b\u0019\t\u0003\u0006\u0002\f\u0002A\t\u0011)Q\u0007\u0003_\n1\u0002Z3wS\u000e,\u0017J\u001c4pA!9\u0011q\u0012\u0001\u0005B\u0005E\u0015!D4fi\u0012+g/[2f\u0013:4w\u000e\u0006\u0002\u0002\u0014B1\u0011QSAN\u000b\u0016k!!a&\u000b\u0007\u0005eU/\u0001\u0003vi&d\u0017\u0002BA?\u0003/Cq!a(\u0001\t\u0003\t\t+\u0001\u0005hKRd\u0015MY3m)\u0019\t\u0019+a+\u0002<B)\u0001%!\u0003\u0002&B\u0019\u0001%a*\n\u0007\u0005%\u0016E\u0001\u0004B]f\u0014VM\u001a\u0005\t\u0003[\u000bi\n1\u0001\u00020\u000691m\u001c8uKb$\b\u0003BAY\u0003ok!!a-\u000b\u0007\u0005U&#A\u0004nC\u000eD\u0017N\\3\n\t\u0005e\u00161\u0017\u0002\b\u0007>tG/\u001a=u\u0011!\ti,!(A\u0002\u0005}\u0016\u0001B1sON\u0004B!!-\u0002B&!\u00111YAZ\u0005%\t%oZ;nK:$8\u000f\u000b\u0007\u0002\u001e\u0006\u001d\u0017QZAh\u0003#\f\u0019\u000e\u0005\u0003\u00022\u0006%\u0017\u0002BAf\u0003g\u0013\u0001bQ1mY\n\f7m[\u0001\u0007I&\u0014Xm\u0019;\u001a\u0003\u0005\t1\u0001Z8dC\t\t).\u0001\u001dgk:\u001cG/[8oQ%R4\u000f\u001e:j]\u001e\u0004S&\f\u0011HKR\u0004C\u000f[3!GV\u0014(/\u001a8uA1\f'-\u001a7!_\u001a\u0004C\u000f[3!IJLg/\u001a\u0018\t\u000f\u0005e\u0007\u0001\"\u0001\u0002\\\u0006A1/\u001a;MC\n,G\u000e\u0006\u0004\u0002$\u0006u\u0017q\u001c\u0005\t\u0003[\u000b9\u000e1\u0001\u00020\"A\u0011QXAl\u0001\u0004\ty\f\u000b\u0005\u0002X\u0006\u001d\u0017\u0011[ArC\t\t)/\u00017gk:\u001cG/[8oQY\fG.^3;gR\u0014\u0018N\\4*uM$(/\u001b8hA5j\u0003eU3ug\u0002\"\b.\u001a\u0011mC\n,G\u000eI8gAQDW\r\t3sSZ,g\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004c.Z<!m\u0006dW/\u001a\u0017!o\"L7\r\u001b\u0011nCf\u0004#-\u001a\u0011ueVt7-\u0019;fI:Bq!!;\u0001\t\u0003\tY/A\u0006hKR\u001c\u0015\r]1dSRLHCBAR\u0003[\fy\u000f\u0003\u0005\u0002.\u0006\u001d\b\u0019AAX\u0011!\ti,a:A\u0002\u0005}\u0006\u0006DAt\u0003\u000f\fi-a4\u0002R\u0006M\u0018EAA{\u0003\u001d3WO\\2uS>t\u0007&\u000b\u001eok6\u0014WM\u001d\u0011.[\u0001\u0012V\r^;s]N\u0004C\u000f[3!i>$\u0018\r\u001c\u0011dCB\f7-\u001b;zA=4\u0007\u0005\u001e5fA\u0011\u0014\u0018N^3-A%t\u0007EY=uKNt\u0003bBA}\u0001\u0011\u0005\u00111`\u0001\u000eO\u0016$8+Z2u_J\u001c\u0016N_3\u0015\r\u0005\r\u0016Q`A\u0000\u0011!\ti+a>A\u0002\u0005=\u0006\u0002CA_\u0003o\u0004\r!a0)\u0019\u0005]\u0018qYAg\u0003\u001f\f\tNa\u0001\"\u0005\t\u0015\u0011\u0001\u00154v]\u000e$\u0018n\u001c8)SirW/\u001c2fe\u0002jS\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u00043/\u001b>fA=4\u0007%\u0019\u0011tS:<G.\u001a\u0011tK\u000e$xN\u001d\u0011p]\u0002\"\b.\u001a\u0011ee&4X\r\f\u0011j]\u0002\u0012\u0017\u0010^3t]!9!\u0011\u0002\u0001\u0005\u0002\t-\u0011aD4fiBc\u0017\r\u001e;fe\u000e{WO\u001c;\u0015\r\u0005\r&Q\u0002B\b\u0011!\tiKa\u0002A\u0002\u0005=\u0006\u0002CA_\u0005\u000f\u0001\r!a0)\u0019\t\u001d\u0011qYAg\u0003\u001f\f\tNa\u0005\"\u0005\tU\u0011!\u00114v]\u000e$\u0018n\u001c8)SirW/\u001c2fe\u0002jS\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004c.^7cKJ\u0004sN\u001a\u0011qY\u0006$H/\u001a:tA%t\u0007\u0005\u001e5fA\u0011\u0014\u0018N^3/\u0011\u001d\u0011I\u0002\u0001C\u0001\u00057\t!B]3bIN+7\r^8s)\u0019\t\u0019K!\b\u0003 !A\u0011Q\u0016B\f\u0001\u0004\ty\u000b\u0003\u0005\u0002>\n]\u0001\u0019AA`Q1\u00119\"a2\u0002N\u0006=\u0017\u0011\u001bB\u0012C\t\u0011)#\u0001+gk:\u001cG/[8oQM,7\r^8su9,XNY3sSi\u001aHO]5oO\u0002jS\u0006\t*fC\u0012\u0004C\u000f[3!GV\u0014(/\u001a8uA\r|g\u000e^3oiN\u0004sN\u001a\u0011uQ\u0016\u00043\u000f]3dS\u001aLW\r\u001a\u0011tK\u000e$xN\u001d\u0018\t\u000f\t%\u0002\u0001\"\u0001\u0003,\u0005YqO]5uKN+7\r^8s)\u0019\t\u0019K!\f\u00030!A\u0011Q\u0016B\u0014\u0001\u0004\ty\u000b\u0003\u0005\u0002>\n\u001d\u0002\u0019AA`Q1\u00119#a2\u0002N\u0006=\u0017\u0011\u001bB\u001aC\t\u0011)$\u00010gk:\u001cG/[8oQM,7\r^8su9,XNY3sY\u00012\u0018\r\\;fuM$(/\u001b8hS\u0001jS\u0006I,sSR,\u0007\u0005\u001e5fAM\u0004XmY5gS\u0016$\u0007eY8oi\u0016tGo\u001d\u0011u_\u0002\"\b.\u001a\u0011ta\u0016\u001c\u0017NZ5fI\u0002\u001aXm\u0019;pe:BqA!\u000f\u0001\t\u0003\u0011Y$\u0001\u0005sK\u0006$')\u001f;f)\u0019\t\u0019K!\u0010\u0003@!A\u0011Q\u0016B\u001c\u0001\u0004\ty\u000b\u0003\u0005\u0002>\n]\u0002\u0019AA`Q1\u00119$a2\u0002N\u0006=\u0017\u0011\u001bB\"C\t\u0011)%A'gk:\u001cG/[8oQ=4gm]3uu9,XNY3sSirW/\u001c2fe\u0002jS\u0006\t*fC\u0012\u0004\u0013\rI:j]\u001edW\r\t2zi\u0016\u0004\u0013\r\u001e\u0011uQ\u0016\u00043\u000f]3dS\u001aLW\r\u001a\u0011pM\u001a\u001cX\r\u001e\u0018\t\u000f\t%\u0003\u0001\"\u0001\u0003L\u0005IqO]5uK\nKH/\u001a\u000b\u0007\u0003G\u0013iEa\u0014\t\u0011\u00055&q\ta\u0001\u0003_C\u0001\"!0\u0003H\u0001\u0007\u0011q\u0018\u0015\r\u0005\u000f\n9-!4\u0002P\u0006E'1K\u0011\u0003\u0005+\nQKZ;oGRLwN\u001c\u0015pM\u001a\u001cX\r\u001e\u001eok6\u0014WM\u001d\u0017!m\u0006dW/\u001a\u001eok6\u0014WM]\u0015![5\u0002sK]5uK\u0002\n\u0007e]5oO2,\u0007EY=uK\u0002\"x\u000e\t;iK\u0002\u001a\b/Z2jM&,G\rI8gMN,GO\f\u0005\n\u00053\u0002!\u0019!C\u0007\u00057\n!\u0002S3bIB{7\u000fV1h+\t\u0011if\u0004\u0002\u0003`\u0005\u0012\u0011\u0011\u0006\u0005\t\u0005G\u0002\u0001\u0015!\u0004\u0003^\u0005Y\u0001*Z1e!>\u001cH+Y4!\u0011\u001d\u00119\u0007\u0001C!\u0005S\nA\u0001\\8bIR!\u0011\u0011\u0007B6\u0011!\u0011iG!\u001aA\u0002\t=\u0014a\u00018ciB!!\u0011\u000fB?\u001b\t\u0011\u0019H\u0003\u0003\u0003n\tU$\u0002\u0002B<\u0005s\n\u0011\"\\5oK\u000e\u0014\u0018M\u001a;\u000b\u0005\tm\u0014a\u00018fi&!!q\u0010B:\u00059q%\t\u0016+bO\u000e{W\u000e]8v]\u0012DqAa!\u0001\t\u0003\u0012))\u0001\u0003tCZ,G\u0003BA\u0019\u0005\u000fC\u0001B!\u001c\u0003\u0002\u0002\u0007!q\u000e\u0005\b\u0005\u0017\u0003A\u0011\u0002BG\u000391\u0018\r\\5eCR,7+Z2u_J$2a\bBH\u0011\u001d\u0011\tJ!#A\u0002}\taa]3di>\u0014\bb\u0002BK\u0001\u0011%!qS\u0001\fG\",7m[*fGR|'\u000fF\u0002 \u00053CqAa'\u0003\u0014\u0002\u0007q$\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\b\u0005+\u0003A\u0011\u0002BP)\u0015y\"\u0011\u0015BR\u0011!\tiL!(A\u0002\u0005}\u0006b\u0002BS\u0005;\u0003\raH\u0001\u0002]\"9!\u0011\u0016\u0001\u0005\n\t-\u0016\u0001D7pm\u0016$vnU3di>\u0014H#B\u0010\u0003.\n=\u0006\u0002CAW\u0005O\u0003\r!a,\t\u000f\tE%q\u0015a\u0001?!9!1\u0017\u0001\u0005\n\tU\u0016aD:fGR|'\u000fV8IK\u0006$\u0007k\\:\u0015\u0007}\u00119\fC\u0004\u0003\u0012\nE\u0006\u0019A\u0010\t\u000f\tm\u0006\u0001\"\u0003\u0003>\u0006a1/Z2u_J|eMZ:fiR\u0019qDa0\t\u000f\tE%\u0011\u0018a\u0001?!9!1\u0019\u0001\u0005\n\t\u0015\u0017\u0001D8gMN,GoU3di>\u0014HcA\u0010\u0003H\"9!1\u0014Ba\u0001\u0004y\u0002b\u0002Bf\u0001\u0011%!QZ\u0001\rI&\u001c8.Q2uSZLG/\u001f\u000b\u0003\u0003c\u0001")
public class Drive
extends AbstractManagedEnvironment
implements DeviceInfo {
    private final int capacity;
    private final int platterCount;
    private final Label label;
    private final Option<EnvironmentHost> host;
    private final Option<String> sound;
    private final int speed;
    private final boolean isLocked;
    private final ComponentConnector node;
    private final int sectorSize;
    private final byte[] data;
    private final int sectorCount;
    private final int sectorsPerPlatter;
    private int headPos;
    private final double[] readSectorCosts;
    private final double[] writeSectorCosts;
    private final double[] readByteCosts;
    private final double[] writeByteCosts;
    private Map<String, String> deviceInfo;
    private final String HeadPosTag;
    private volatile boolean bitmap$0;

    private Map deviceInfo$lzycompute() {
        Drive drive = this;
        synchronized (drive) {
            if (!this.bitmap$0) {
                this.deviceInfo = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)"disk"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"description"), (Object)"Hard disk drive"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"vendor"), (Object)"MightyPirates GmbH & Co. KG"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"product"), (Object)new StringBuilder().append((Object)"MPD").append((Object)((Object)BoxesRunTime.boxToInteger((int)(this.capacity() / 1024))).toString()).append((Object)"L").append((Object)((Object)BoxesRunTime.boxToInteger((int)this.platterCount())).toString()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"capacity"), (Object)((Object)BoxesRunTime.boxToInteger((int)((int)((double)this.capacity() * 1.024)))).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)((Object)BoxesRunTime.boxToInteger((int)this.capacity())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clock"), (Object)new StringBuilder().append((Object)((Object)BoxesRunTime.boxToInteger((int)((int)((double)2000 / this.readSectorCosts()[this.speed()]) / 100))).toString()).append((Object)"/").append((Object)((Object)BoxesRunTime.boxToInteger((int)((int)((double)2000 / this.writeSectorCosts()[this.speed()]) / 100))).toString()).append((Object)"/").append((Object)((Object)BoxesRunTime.boxToInteger((int)((int)((double)2000 / this.readByteCosts()[this.speed()]) / 100))).toString()).append((Object)"/").append((Object)((Object)BoxesRunTime.boxToInteger((int)((int)((double)2000 / this.writeByteCosts()[this.speed()]) / 100))).toString()).toString())}));
                this.bitmap$0 = true;
            }
            return this.deviceInfo;
        }
    }

    public int capacity() {
        return this.capacity;
    }

    public int platterCount() {
        return this.platterCount;
    }

    public Label label() {
        return this.label;
    }

    public Option<String> sound() {
        return this.sound;
    }

    public int speed() {
        return this.speed;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    @Override
    public ComponentConnector node() {
        return this.node;
    }

    private File savePath() {
        return new File(DimensionManager.getCurrentSaveRootDirectory(), new StringBuilder().append((Object)Settings$.MODULE$.savePath()).append((Object)this.node().address()).append((Object)".bin").toString());
    }

    private final int sectorSize() {
        return 512;
    }

    private byte[] data() {
        return this.data;
    }

    private int sectorCount() {
        return this.sectorCount;
    }

    private int sectorsPerPlatter() {
        return this.sectorsPerPlatter;
    }

    private int headPos() {
        return this.headPos;
    }

    private void headPos_$eq(int x$1) {
        this.headPos = x$1;
    }

    public final double[] readSectorCosts() {
        return this.readSectorCosts;
    }

    public final double[] writeSectorCosts() {
        return this.writeSectorCosts;
    }

    public final double[] readByteCosts() {
        return this.readByteCosts;
    }

    public final double[] writeByteCosts() {
        return this.writeByteCosts;
    }

    private final Map<String, String> deviceInfo() {
        return this.bitmap$0 ? this.deviceInfo : this.deviceInfo$lzycompute();
    }

    @Override
    public java.util.Map<String, String> getDeviceInfo() {
        return WrapAsJava$.MODULE$.mapAsJavaMap(this.deviceInfo());
    }

    @Callback(direct=true, doc="function():string -- Get the current label of the drive.")
    public synchronized Object[] getLabel(Context context, Arguments args) {
        return this.label() == null ? null : package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.label().getLabel()}));
    }

    @Callback(doc="function(value:string):string -- Sets the label of the drive. Returns the new value, which may be truncated.")
    public synchronized Object[] setLabel(Context context, Arguments args) {
        if (this.isLocked()) {
            throw new Exception("drive is read only");
        }
        if (this.label() == null) {
            throw new Exception("drive does not support labeling");
        }
        if (args.checkAny(0) == null) {
            this.label().setLabel(null);
        } else {
            this.label().setLabel(args.checkString(0));
        }
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.label().getLabel()}));
    }

    @Callback(direct=true, doc="function():number -- Returns the total capacity of the drive, in bytes.")
    public Object[] getCapacity(Context context, Arguments args) {
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.capacity())}));
    }

    @Callback(direct=true, doc="function():number -- Returns the size of a single sector on the drive, in bytes.")
    public Object[] getSectorSize(Context context, Arguments args) {
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)512)}));
    }

    @Callback(direct=true, doc="function():number -- Returns the number of platters in the drive.")
    public Object[] getPlatterCount(Context context, Arguments args) {
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.platterCount())}));
    }

    @Callback(direct=true, doc="function(sector:number):string -- Read the current contents of the specified sector.")
    public synchronized Object[] readSector(Context context, Arguments args) {
        context.consumeCallBudget(this.readSectorCosts()[this.speed()]);
        int sector = this.moveToSector(context, this.checkSector(args, 0));
        this.diskActivity();
        byte[] sectorData = new byte[512];
        Array$.MODULE$.copy((Object)this.data(), this.sectorOffset(sector), (Object)sectorData, 0, 512);
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sectorData}));
    }

    @Callback(direct=true, doc="function(sector:number, value:string) -- Write the specified contents to the specified sector.")
    public synchronized Object[] writeSector(Context context, Arguments args) {
        if (this.isLocked()) {
            throw new Exception("drive is read only");
        }
        context.consumeCallBudget(this.writeSectorCosts()[this.speed()]);
        byte[] sectorData = args.checkByteArray(1);
        int sector = this.moveToSector(context, this.checkSector(args, 0));
        this.diskActivity();
        Array$.MODULE$.copy((Object)sectorData, 0, (Object)this.data(), this.sectorOffset(sector), scala.math.package$.MODULE$.min(512, sectorData.length));
        return null;
    }

    @Callback(direct=true, doc="function(offset:number):number -- Read a single byte at the specified offset.")
    public synchronized Object[] readByte(Context context, Arguments args) {
        context.consumeCallBudget(this.readByteCosts()[this.speed()]);
        int offset = args.checkInteger(0) - 1;
        this.moveToSector(context, this.checkSector(offset));
        this.diskActivity();
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)this.data()[offset])}));
    }

    @Callback(direct=true, doc="function(offset:number, value:number) -- Write a single byte to the specified offset.")
    public synchronized Object[] writeByte(Context context, Arguments args) {
        if (this.isLocked()) {
            throw new Exception("drive is read only");
        }
        context.consumeCallBudget(this.writeByteCosts()[this.speed()]);
        int offset = args.checkInteger(0) - 1;
        byte value = (byte)args.checkInteger(1);
        this.moveToSector(context, this.checkSector(offset));
        this.diskActivity();
        this.data()[offset] = value;
        return null;
    }

    private final String HeadPosTag() {
        return "headPos";
    }

    @Override
    public synchronized void load(NBTTagCompound nbt) {
        super.load(nbt);
        if (this.node().address() != null) {
            try {
                File path = this.savePath();
                if (path.exists()) {
                    ByteArrayInputStream bin = new ByteArrayInputStream(Files.toByteArray((File)path));
                    GZIPInputStream zin = new GZIPInputStream(bin);
                    int read = 0;
                    for (int offset = 0; read >= 0 && offset < this.data().length; offset += read) {
                        read = zin.read(this.data(), offset, this.data().length - offset);
                    }
                }
            }
            catch (Throwable throwable) {
                OpenComputers$.MODULE$.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed loading drive contents for '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.node().address()})), throwable);
            }
        }
        this.headPos_$eq(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(nbt.func_74762_e("headPos")), 0)), this.sectorToHeadPos(this.sectorCount())));
        if (this.label() != null) {
            this.label().load(nbt);
        }
    }

    @Override
    public synchronized void save(NBTTagCompound nbt) {
        super.save(nbt);
        if (this.node().address() != null) {
            try {
                File path = this.savePath();
                path.getParentFile().mkdirs();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                GZIPOutputStream zos = new GZIPOutputStream(bos);
                zos.write(this.data());
                zos.close();
                Files.write((byte[])bos.toByteArray(), (File)path);
            }
            catch (Throwable throwable) {
                OpenComputers$.MODULE$.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed saving drive contents for '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.node().address()})), throwable);
            }
        }
        nbt.func_74768_a("headPos", this.headPos());
        if (this.label() != null) {
            this.label().save(nbt);
        }
    }

    private int validateSector(int sector) {
        if (sector < 0 || sector >= this.sectorCount()) {
            throw new IllegalArgumentException("invalid offset, not in a usable sector");
        }
        return sector;
    }

    private int checkSector(int offset) {
        return this.validateSector(this.offsetSector(offset));
    }

    private int checkSector(Arguments args, int n) {
        return this.validateSector(args.checkInteger(n) - 1);
    }

    private int moveToSector(Context context, int sector) {
        int newHeadPos = this.sectorToHeadPos(sector);
        if (this.headPos() != newHeadPos) {
            int delta = scala.math.package$.MODULE$.abs(this.headPos() - newHeadPos);
            Object object = delta > Settings$.MODULE$.get().sectorSeekThreshold() ? BoxesRunTime.boxToBoolean((boolean)context.pause(Settings$.MODULE$.get().sectorSeekTime())) : BoxedUnit.UNIT;
            this.headPos_$eq(newHeadPos);
        }
        return sector;
    }

    private int sectorToHeadPos(int sector) {
        return sector % this.sectorsPerPlatter();
    }

    private int sectorOffset(int sector) {
        return sector * 512;
    }

    private int offsetSector(int offset) {
        return offset / 512;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void diskActivity() {
        Tuple2 tuple2 = new Tuple2(this.sound(), this.host);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                String s = (String)some.x();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    EnvironmentHost h = (EnvironmentHost)some2.x();
                    PacketSender$.MODULE$.sendFileSystemActivity(this.node(), h, s);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Drive(int capacity, int platterCount, Label label, Option<EnvironmentHost> host, Option<String> sound, int speed, boolean isLocked) {
        this.capacity = capacity;
        this.platterCount = platterCount;
        this.label = label;
        this.host = host;
        this.sound = sound;
        this.speed = speed;
        this.isLocked = isLocked;
        this.node = (ComponentConnector)Network.newNode(this, Visibility.Network).withComponent("drive", Visibility.Neighbors).withConnector().create();
        this.data = new byte[capacity];
        this.sectorCount = capacity / 512;
        this.sectorsPerPlatter = this.sectorCount() / platterCount;
        this.headPos = 0;
        this.readSectorCosts = new double[]{0.1, 0.05, 0.03333333333333333, 0.025, 0.02, 0.016666666666666666};
        this.writeSectorCosts = new double[]{0.2, 0.1, 0.06666666666666667, 0.05, 0.04, 0.03333333333333333};
        this.readByteCosts = new double[]{0.020833333333333332, 0.015625, 0.0125, 0.010416666666666666, 0.008928571428571428, 0.0078125};
        this.writeByteCosts = new double[]{0.041666666666666664, 0.03125, 0.025, 0.020833333333333332, 0.017857142857142856, 0.015625};
    }
}

